/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.quantumwaveinterference.davissongermer.DGIntensityReader;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGModel;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import java.awt.Point;

public class EdgeIntensityReader
implements DGIntensityReader {
    private int inset = 5;
    private DGModel dgModel;

    public EdgeIntensityReader(DGModel dGModel) {
        this.dgModel = dGModel;
    }

    public double getIntensity(double d) {
        Point point = this.toGridLocation(d);
        Complex complex = this.getWavefunction().valueAt(point.x, point.y);
        return complex.abs();
    }

    private Wavefunction getWavefunction() {
        return this.dgModel.getWavefunction();
    }

    private Point toGridLocation(double d) {
        double d2 = this.getThreshold();
        if (d < d2) {
            return this.toGridLocationBottom(d);
        }
        return this.toGridLocationSide(d);
    }

    private double getThreshold() {
        return Math.toDegrees(Math.atan2(this.getWavefunction().getWidth() / 2, this.getDistanceFromSouthToCenterAtom()));
    }

    private int getDistanceFromSouthToCenterAtom() {
        return this.getWavefunction().getHeight() - this.dgModel.getCenterAtomPoint().y;
    }

    private Point toGridLocationSide(double d) {
        int n = (int)((double)(this.getWavefunction().getWidth() / 2 - this.inset) * Math.tan(Math.toRadians(90.0 - d)));
        return new Point(this.getWavefunction().getWidth() - this.inset, this.dgModel.getCenterAtomPoint().y + n);
    }

    private Point toGridLocationBottom(double d) {
        int n = (int)((double)(this.getDistanceFromSouthToCenterAtom() - this.inset) * Math.tan(Math.toRadians(d)));
        return new Point(n + this.getWavefunction().getWidth() / 2, this.getWavefunction().getHeight() - this.inset);
    }
}

