/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.controls;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.propagators.AveragePropagator;
import edu.colorado.phet.quantumwaveinterference.model.propagators.ClassicalWavePropagator;
import edu.colorado.phet.quantumwaveinterference.model.propagators.CrankNicholsonPropagator;
import edu.colorado.phet.quantumwaveinterference.model.propagators.ModifiedRichardsonPropagator;
import edu.colorado.phet.quantumwaveinterference.model.propagators.RichardsonPropagator;
import edu.colorado.phet.quantumwaveinterference.model.propagators.SplitOperatorPropagator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class PropagatorPanel
extends VerticalLayoutPanel {
    private QWIModel QWIModel;
    private ClassicalWavePropagator classicalPropagator2ndOrder;

    public PropagatorPanel(QWIModel qWIModel) {
        this.QWIModel = qWIModel;
        PropagatorPanel propagatorPanel = this;
        propagatorPanel.setBorder(BorderFactory.createTitledBorder(QWIResources.getString("propagator")));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = this.createPropagatorButton(buttonGroup, QWIResources.getString("richardson"), new RichardsonPropagator(this.getDiscreteModel().getDeltaTime(), this.getDiscreteModel().getPotential(), 1.0, 1.0));
        propagatorPanel.add(jRadioButton);
        JRadioButton jRadioButton2 = this.createPropagatorButton(buttonGroup, QWIResources.getString("modified.richardson"), new ModifiedRichardsonPropagator(this.getDiscreteModel().getDeltaTime(), this.getDiscreteModel().getPotential(), 1.0, 1.0));
        propagatorPanel.add(jRadioButton2);
        JRadioButton jRadioButton3 = this.createPropagatorButton(buttonGroup, QWIResources.getString("crank.nicholson"), new CrankNicholsonPropagator(this.getDiscreteModel().getDeltaTime(), this.getDiscreteModel().getBoundaryCondition(), this.getDiscreteModel().getPotential()));
        propagatorPanel.add(jRadioButton3);
        JRadioButton jRadioButton4 = this.createPropagatorButton(buttonGroup, QWIResources.getString("avg"), new AveragePropagator(this.getDiscreteModel().getPotential()));
        propagatorPanel.add(jRadioButton4);
        this.classicalPropagator2ndOrder = new ClassicalWavePropagator(this.getDiscreteModel().getPotential());
        JRadioButton jRadioButton5 = this.createPropagatorButton(buttonGroup, QWIResources.getString("finite.difference"), this.classicalPropagator2ndOrder);
        JRadioButton jRadioButton6 = this.createPropagatorButton(buttonGroup, QWIResources.getString("split.operator"), new SplitOperatorPropagator(this.getDiscreteModel(), this.getDiscreteModel().getPotential()));
        propagatorPanel.add(jRadioButton6);
        propagatorPanel.add(jRadioButton5);
        jRadioButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropagatorPanel.this.initClassicalWave(PropagatorPanel.this.classicalPropagator2ndOrder);
            }
        });
    }

    private QWIModel getDiscreteModel() {
        return this.QWIModel;
    }

    private JRadioButton createPropagatorButton(ButtonGroup buttonGroup, String string, final Propagator propagator) {
        final JRadioButton jRadioButton = new JRadioButton(string);
        buttonGroup.add(jRadioButton);
        if (this.getDiscreteModel().getPropagator().getClass().equals(propagator.getClass())) {
            jRadioButton.setSelected(true);
        }
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropagatorPanel.this.getDiscreteModel().setPropagator(propagator);
            }
        });
        jRadioButton.setSelected(this.getDiscreteModel().getPropagator().getClass().isAssignableFrom(propagator.getClass()));
        this.getDiscreteModel().addListener(new QWIModel.Adapter(){

            public void propagatorChanged() {
                jRadioButton.setSelected(PropagatorPanel.this.getDiscreteModel().getPropagator().getClass().equals(propagator.getClass()));
            }
        });
        return jRadioButton;
    }

    private void initClassicalWave(ClassicalWavePropagator classicalWavePropagator) {
    }
}

