/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.controls;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.IVisualizationPanel;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.WaveValueAccessor;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.ComplexColorMap;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.GrayscaleColorMap;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.MagnitudeColorMap;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.VisualColorMap3;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;

public class ParticleVisualizationPanel
extends VerticalLayoutPanel
implements IVisualizationPanel {
    private QWIPanel QWIPanel;
    private IVisualizationPanel.VisButton phaseColorRadioButton;
    private ButtonGroup buttonGroup;
    private IVisualizationPanel.VisButton grayMag;
    private IVisualizationPanel.VisButton realGray;
    private IVisualizationPanel.VisButton complexGray;
    private IVisualizationPanel.VisButton[] v;
    private IVisualizationPanel.VisButton lastUserSelected;

    public ParticleVisualizationPanel(QWIPanel qWIPanel) {
        this.QWIPanel = qWIPanel;
        this.setBorder(BorderFactory.createTitledBorder(QWIResources.getString("wave.function.display")));
        this.buttonGroup = new ButtonGroup();
        this.grayMag = this.createVisualizationButton(QWIResources.getString("magnitude"), new MagnitudeColorMap(), new WaveValueAccessor.Magnitude(), true, this.buttonGroup);
        this.addFullWidth(this.grayMag);
        this.realGray = this.createVisualizationButton(QWIResources.getString("real.part"), new GrayscaleColorMap.Real(), new WaveValueAccessor.Real(), false, this.buttonGroup);
        this.addFullWidth(this.realGray);
        this.complexGray = this.createVisualizationButton(QWIResources.getString("imaginary.part"), new GrayscaleColorMap.Imaginary(), new WaveValueAccessor.Imag(), false, this.buttonGroup);
        this.addFullWidth(this.complexGray);
        this.phaseColorRadioButton = this.createVisualizationButton(QWIResources.getString("phase.color"), new VisualColorMap3(), new WaveValueAccessor.Magnitude(), false, this.buttonGroup);
        this.addFullWidth(this.phaseColorRadioButton);
        this.v = new IVisualizationPanel.VisButton[]{this.grayMag, this.realGray, this.complexGray, this.phaseColorRadioButton};
    }

    private IVisualizationPanel.VisButton createVisualizationButton(String string, final ComplexColorMap complexColorMap, final WaveValueAccessor waveValueAccessor, boolean bl, ButtonGroup buttonGroup) {
        final IVisualizationPanel.VisButton visButton = new IVisualizationPanel.VisButton(string, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleVisualizationPanel.this.QWIPanel.setVisualizationStyle(complexColorMap, waveValueAccessor);
            }
        });
        visButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleVisualizationPanel.this.lastUserSelected = visButton;
            }
        });
        buttonGroup.add(visButton);
        visButton.setSelected(bl);
        return visButton;
    }

    public void setPhaseColorEnabled(boolean bl) {
        this.phaseColorRadioButton.setEnabled(bl);
    }

    public Component getPanel() {
        return this;
    }

    public void applyChanges() {
        for (int i = 0; i < this.v.length; ++i) {
            IVisualizationPanel.VisButton visButton = this.v[i];
            if (!visButton.isSelected()) continue;
            visButton.fireEvent();
        }
    }

    public void setMagnitudeMode() {
        this.grayMag.setSelected(true);
        this.applyChanges();
    }

    public void setLastUserSelected() {
        if (this.lastUserSelected != null) {
            this.lastUserSelected.setSelected(true);
            this.applyChanges();
        }
    }
}

