/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.controls;

import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.QWIControlPanel;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.DetectorSheetPNode;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.IntensityManager;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IntensityScreenPanel
extends VerticalLayoutPanel {
    private QWIControlPanel qwiControlPanel;

    public IntensityScreenPanel(QWIControlPanel qWIControlPanel) {
        this.qwiControlPanel = qWIControlPanel;
        this.setBorder(BorderFactory.createTitledBorder(QWIResources.getString("intensity.screen")));
        final IntensityManager intensityManager = qWIControlPanel.getModule().getIntensityDisplay();
        HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(intensityManager.getProbabilityScaleFudgeFactor(), 0.0, 1000.0, 0.1));
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = ((Number)jSpinner.getValue()).doubleValue();
                intensityManager.setProbabilityScaleFudgeFactor(d);
            }
        });
        ((Container)horizontalLayoutPanel).add(new JLabel(QWIResources.getString("probability.inflation")));
        ((Container)horizontalLayoutPanel).add(jSpinner);
        super.addFullWidth(horizontalLayoutPanel);
        HorizontalLayoutPanel horizontalLayoutPanel2 = new HorizontalLayoutPanel();
        ((Container)horizontalLayoutPanel2).add(new JLabel(QWIResources.getString("waveform.decrement")));
        final JSpinner jSpinner2 = new JSpinner(new SpinnerNumberModel(intensityManager.getNormDecrement(), 0.0, 1.0, 0.1));
        jSpinner2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = ((Number)jSpinner2.getValue()).doubleValue();
                intensityManager.setNormDecrement(d);
            }
        });
        ((Container)horizontalLayoutPanel2).add(jSpinner2);
        super.addFullWidth(horizontalLayoutPanel2);
        HorizontalLayoutPanel horizontalLayoutPanel3 = new HorizontalLayoutPanel();
        ((Container)horizontalLayoutPanel3).add(new JLabel(QWIResources.getString("multiplier")));
        final JSpinner jSpinner3 = new JSpinner(new SpinnerNumberModel(intensityManager.getMultiplier(), 0, 1000, 5));
        jSpinner3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                intensityManager.setMultiplier(((Number)jSpinner3.getValue()).intValue());
            }
        });
        ((Container)horizontalLayoutPanel3).add(jSpinner3);
        super.addFullWidth(horizontalLayoutPanel3);
        HorizontalLayoutPanel horizontalLayoutPanel4 = new HorizontalLayoutPanel();
        ((Container)horizontalLayoutPanel4).add(new JLabel(QWIResources.getString("opacity")));
        int n = this.getDetectorSheetPNode().getOpacity();
        n = Math.max(n, 0);
        n = Math.min(n, 255);
        final JSpinner jSpinner4 = new JSpinner(new SpinnerNumberModel(n, 0, 255, 1));
        jSpinner4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = ((Number)jSpinner4.getValue()).intValue();
                IntensityScreenPanel.this.getDetectorSheetPNode().setOpacity(n);
            }
        });
        ((Container)horizontalLayoutPanel4).add(jSpinner4);
        this.addFullWidth(horizontalLayoutPanel4);
    }

    private DetectorSheetPNode getDetectorSheetPNode() {
        return this.qwiControlPanel.getSchrodingerPanel().getDetectorSheetPNode();
    }
}

