/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.model.clock;

import edu.colorado.phet.common.phetcommon.model.clock.Clock;
import edu.colorado.phet.common.phetcommon.model.clock.TimingStrategy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class SwingClock
extends Clock {
    private Timer timer;

    public SwingClock(int n, double d) {
        this(n, new TimingStrategy.Constant(d));
    }

    public SwingClock(int n, TimingStrategy timingStrategy) {
        super(timingStrategy);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!SwingClock.this.isPaused()) {
                    SwingClock.this.doTick();
                }
            }
        };
        this.timer = new Timer(n, actionListener);
    }

    public void start() {
        if (this.isPaused()) {
            this.timer.start();
            super.notifyClockStarted();
        }
    }

    public void pause() {
        if (this.isRunning()) {
            this.timer.stop();
            super.notifyClockPaused();
        }
    }

    public boolean isPaused() {
        return !this.timer.isRunning();
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    public void setDelay(int n) {
        this.timer.setDelay(n);
    }
}

