/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class PhaseRenderer
extends AbstractXYItemRenderer {
    private GeneralPath _polygonPath = new GeneralPath();

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        if (n2 % 2 == 1) {
            return;
        }
        if (n2 == xYDataset.getItemCount(n) - 2) {
            return;
        }
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        double d3 = xYDataset.getXValue(n, n2 + 2);
        double d4 = xYDataset.getYValue(n, n2 + 2);
        double d5 = xYDataset.getYValue(n, n2 + 1);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d6 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d7 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d8 = valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge2);
        double d9 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        double d10 = valueAxis2.valueToJava2D(d4, rectangle2D, rectangleEdge2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = this.phaseToRGB(d5);
        graphics2D.setPaint(color);
        this._polygonPath.reset();
        this._polygonPath.moveTo((float)d6, (float)d8);
        this._polygonPath.lineTo((float)d6, (float)d9);
        this._polygonPath.lineTo((float)d7, (float)d10);
        this._polygonPath.lineTo((float)d7, (float)d8);
        this._polygonPath.closePath();
        graphics2D.fill(this._polygonPath);
    }

    private Color phaseToRGB(double d) {
        float f = (float)Math.toDegrees(d) % 360.0f / 360.0f;
        return Color.getHSBColor(f, 1.0f, 1.0f);
    }
}

