/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.util;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Random;

public class Distribution
implements Serializable,
Cloneable {
    private Hashtable _hashTable = new Hashtable();

    public void add(Object object, double d) {
        if (d < 0.0) {
            throw new RuntimeException("Negative weights not supported in a distribution: " + d);
        }
        double d2 = d;
        if (this._hashTable.containsKey(object)) {
            d2 = this.getWeight(object) + d;
        }
        this.setWeight(object, d2);
    }

    private Object[] getObjects() {
        return this._hashTable.keySet().toArray();
    }

    private void setWeight(Object object, double d) {
        this._hashTable.put(object, new Double(d));
    }

    protected double getWeight(Object object) {
        if (!this._hashTable.containsKey(object)) {
            return 0.0;
        }
        Object v = this._hashTable.get(object);
        Double d = (Double)v;
        return d;
    }

    private double getTotalWeight() {
        double d = 0.0;
        for (Object k : this._hashTable.keySet()) {
            d += this.getWeight(k);
        }
        return d;
    }

    public Object clone() {
        try {
            Distribution distribution = (Distribution)super.clone();
            distribution._hashTable = (Hashtable)this._hashTable.clone();
            return distribution;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public String toString() {
        return this._hashTable.toString();
    }

    public static class DistributionAccessor {
        private Distribution _distribution;
        private Random _random;

        public DistributionAccessor(Distribution distribution, Random random) {
            this._distribution = distribution;
            this._random = random;
        }

        public Object nextObject() {
            double d = this._distribution.getTotalWeight();
            if (d <= 0.0) {
                return null;
            }
            double d2 = this._random.nextDouble() * d;
            double d3 = 0.0;
            Object[] objectArray = this._distribution.getObjects();
            for (int i = 0; i < objectArray.length; ++i) {
                double d4 = this._distribution.getWeight(objectArray[i]);
                if (!(d2 <= (d3 += d4))) continue;
                return objectArray[i];
            }
            throw new RuntimeException("Value not found in distribution: value=" + d2 + ", at=" + d3);
        }
    }
}

