/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

public class PotentialRegion {
    private double _start;
    private double _end;
    private double _energy;

    public PotentialRegion(double d, double d2, double d3) {
        if (d >= d2) {
            throw new IllegalArgumentException("start >= end, region must have a positive width");
        }
        this._start = d;
        this._end = d2;
        this._energy = d3;
    }

    public double getStart() {
        return this._start;
    }

    public double getEnd() {
        return this._end;
    }

    public double getMiddle() {
        return this._start + this.getWidth() / 2.0;
    }

    public double getEnergy() {
        return this._energy;
    }

    public double getWidth() {
        double d = 0.0;
        d = this._start == Double.NEGATIVE_INFINITY || this._end == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : this._end - this._start;
        return d;
    }
}

