/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.debug;

import edu.colorado.phet.quantumtunneling.control.RichardsonControlsDialog;
import edu.colorado.phet.quantumtunneling.model.RichardsonSolver;
import edu.colorado.phet.quantumtunneling.module.QTModule;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;

public class RichardsonControlsMenuItem
extends JCheckBoxMenuItem {
    private QTModule _module;
    private RichardsonControlsDialog dialog;

    public RichardsonControlsMenuItem(QTModule qTModule) {
        super("Richardson Controls...");
        this._module = qTModule;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RichardsonControlsMenuItem.this.handleAction();
            }
        });
    }

    private void handleAction() {
        if (this.isSelected()) {
            RichardsonSolver richardsonSolver = this._module.getRichardsonSolver();
            if (richardsonSolver != null) {
                this.dialog = new RichardsonControlsDialog((Frame)this._module.getFrame(), richardsonSolver);
                this.dialog.setVisible(true);
                this.dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        RichardsonControlsMenuItem.this.handleDialogClosed();
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        RichardsonControlsMenuItem.this.handleDialogClosed();
                    }
                });
            }
        } else if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    private void handleDialogClosed() {
        this.dialog = null;
        this.setSelected(false);
    }
}

