/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.control;

import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.control.AbstractDragHandle;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;
import edu.colorado.phet.quantumtunneling.view.QTCombinedChartNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;

public class TotalEnergyDragHandle
extends AbstractDragHandle
implements Observer {
    private TotalEnergy _totalEnergy;
    private QTCombinedChartNode _chartNode;
    private double _xAxisPosition;

    public TotalEnergyDragHandle(QTCombinedChartNode qTCombinedChartNode) {
        super(1);
        this.setValueFormat("0.00");
        this._totalEnergy = null;
        this._chartNode = qTCombinedChartNode;
        this._xAxisPosition = 0.0;
        this.addPropertyChangeListener(this);
        this.updateDragBounds();
    }

    public void setTotalEnergy(TotalEnergy totalEnergy) {
        if (this._totalEnergy != null) {
            this._totalEnergy.deleteObserver(this);
        }
        this._totalEnergy = totalEnergy;
        this._totalEnergy.addObserver(this);
        this.updatePosition();
        this.updateText();
    }

    public void setXAxisPosition(double d) {
        this._xAxisPosition = d;
        this.updatePosition();
    }

    public void updateDragBounds() {
        Point2D point2D = this._chartNode.energyToNode(new Point2D.Double(QTConstants.POSITION_RANGE.getLowerBound(), 0.0));
        Point2D point2D2 = this._chartNode.energyToNode(new Point2D.Double(QTConstants.POSITION_RANGE.getUpperBound(), 0.0));
        Point2D point2D3 = this._chartNode.energyToNode(new Point2D.Double(0.0, QTConstants.ENERGY_RANGE.getLowerBound()));
        Point2D point2D4 = this._chartNode.energyToNode(new Point2D.Double(0.0, QTConstants.ENERGY_RANGE.getUpperBound()));
        double d = point2D.getX();
        double d2 = point2D4.getY();
        double d3 = point2D2.getX() - point2D.getX();
        double d4 = point2D3.getY() - point2D4.getY();
        Rectangle2D rectangle2D = new Rectangle2D.Double(d, d2, d3, d4);
        rectangle2D = this._chartNode.localToGlobal(rectangle2D);
        this.setDragBounds(rectangle2D);
        this.updatePosition();
    }

    private void updatePosition() {
        if (this._totalEnergy != null) {
            Point2D.Double double_ = new Point2D.Double(this._xAxisPosition, this._totalEnergy.getEnergy());
            Point2D point2D = this._chartNode.energyToNode(double_);
            Point2D point2D2 = this._chartNode.localToGlobal(point2D);
            this.removePropertyChangeListener(this);
            this.setGlobalPosition(point2D2);
            this.addPropertyChangeListener(this);
        }
    }

    protected double getModelValue() {
        double d = 0.0;
        if (this._totalEnergy != null) {
            d = this._totalEnergy.getEnergy();
        }
        return d;
    }

    protected void updateModel() {
        if (this._totalEnergy != null) {
            this._totalEnergy.deleteObserver(this);
            Point2D point2D = this.getGlobalPosition();
            Point2D point2D2 = this._chartNode.globalToLocal(point2D);
            Point2D point2D3 = this._chartNode.nodeToEnergy(point2D2);
            this._totalEnergy.setEnergy(point2D3.getY());
            this._totalEnergy.addObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._totalEnergy) {
            this.updatePosition();
            this.updateText();
        }
    }
}

