/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.control;

import edu.colorado.phet.quantumtunneling.control.AbstractDragHandle;
import edu.colorado.phet.quantumtunneling.control.PotentialEnergyDragHandle;
import edu.colorado.phet.quantumtunneling.control.RegionBoundaryDragHandle;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.view.QTCombinedChartNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEventListener;
import java.awt.Color;
import java.util.ArrayList;

public class PotentialEnergyControls
extends PNode {
    private QTCombinedChartNode _chartNode;
    private ArrayList _energyDragHandles;
    private ArrayList _boundaryDragHandles;
    private boolean _valueVisible;
    private Color _valueColor;

    public PotentialEnergyControls(QTCombinedChartNode qTCombinedChartNode) {
        this._chartNode = qTCombinedChartNode;
        this._energyDragHandles = new ArrayList();
        this._boundaryDragHandles = new ArrayList();
        this._valueVisible = false;
        this._valueColor = Color.BLACK;
    }

    public void setValueColor(Color color) {
        AbstractDragHandle abstractDragHandle;
        int n;
        this._valueColor = color;
        for (n = 0; n < this._energyDragHandles.size(); ++n) {
            abstractDragHandle = (PotentialEnergyDragHandle)this._energyDragHandles.get(n);
            abstractDragHandle.setValueColor(this._valueColor);
        }
        for (n = 0; n < this._boundaryDragHandles.size(); ++n) {
            abstractDragHandle = (RegionBoundaryDragHandle)this._boundaryDragHandles.get(n);
            abstractDragHandle.setValueColor(this._valueColor);
        }
    }

    public void setPotentialEnergy(AbstractPotential abstractPotential) {
        AbstractDragHandle abstractDragHandle;
        int n;
        this.removeAllChildren();
        for (n = 0; n < this._energyDragHandles.size(); ++n) {
            abstractDragHandle = (PotentialEnergyDragHandle)this._energyDragHandles.get(n);
            ((PotentialEnergyDragHandle)abstractDragHandle).cleanup();
        }
        this._energyDragHandles.clear();
        for (n = 0; n < this._boundaryDragHandles.size(); ++n) {
            abstractDragHandle = (RegionBoundaryDragHandle)this._boundaryDragHandles.get(n);
            ((RegionBoundaryDragHandle)abstractDragHandle).cleanup();
        }
        this._boundaryDragHandles.clear();
        n = abstractPotential.getNumberOfRegions();
        for (int i = 0; i < n; ++i) {
            PotentialEnergyDragHandle potentialEnergyDragHandle = new PotentialEnergyDragHandle(this._chartNode);
            potentialEnergyDragHandle.setPotentialEnergy(abstractPotential, i);
            potentialEnergyDragHandle.setValueVisible(this._valueVisible);
            potentialEnergyDragHandle.setValueColor(this._valueColor);
            this._energyDragHandles.add(potentialEnergyDragHandle);
            this.addChild(potentialEnergyDragHandle);
            if (i >= n - 1) continue;
            RegionBoundaryDragHandle regionBoundaryDragHandle = new RegionBoundaryDragHandle(this._chartNode);
            regionBoundaryDragHandle.setPotentialEnergy(abstractPotential, i);
            regionBoundaryDragHandle.setValueVisible(this._valueVisible);
            regionBoundaryDragHandle.setValueColor(this._valueColor);
            this._boundaryDragHandles.add(regionBoundaryDragHandle);
            this.addChild(regionBoundaryDragHandle);
        }
        this.updateDragBounds();
    }

    public void setValuesVisible(boolean bl) {
        if (bl != this._valueVisible) {
            AbstractDragHandle abstractDragHandle;
            int n;
            this._valueVisible = bl;
            for (n = 0; n < this._energyDragHandles.size(); ++n) {
                abstractDragHandle = (PotentialEnergyDragHandle)this._energyDragHandles.get(n);
                abstractDragHandle.setValueVisible(this._valueVisible);
            }
            for (n = 0; n < this._boundaryDragHandles.size(); ++n) {
                abstractDragHandle = (RegionBoundaryDragHandle)this._boundaryDragHandles.get(n);
                abstractDragHandle.setValueVisible(this._valueVisible);
            }
        }
    }

    public void addInputEventListener(PInputEventListener pInputEventListener) {
        for (Object object : this._boundaryDragHandles) {
            ((PNode)object).addInputEventListener(pInputEventListener);
        }
        for (PNode pNode : this._energyDragHandles) {
            pNode.addInputEventListener(pInputEventListener);
        }
    }

    public void updateDragBounds() {
        AbstractDragHandle abstractDragHandle;
        int n;
        for (n = 0; n < this._energyDragHandles.size(); ++n) {
            abstractDragHandle = (PotentialEnergyDragHandle)this._energyDragHandles.get(n);
            ((PotentialEnergyDragHandle)abstractDragHandle).updateDragBounds();
        }
        for (n = 0; n < this._boundaryDragHandles.size(); ++n) {
            abstractDragHandle = (RegionBoundaryDragHandle)this._boundaryDragHandles.get(n);
            ((RegionBoundaryDragHandle)abstractDragHandle).updateDragBounds();
        }
    }
}

