/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.control;

import edu.colorado.phet.common.piccolophet.event.ConstrainedDragHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class AbstractDragHandle
extends PPath
implements PropertyChangeListener {
    private static final NumberFormat DEFAULT_VALUE_FORMAT = new DecimalFormat("0.0");
    private int _orientation;
    private int _look;
    private Point2D _registrationPoint;
    private ConstrainedDragHandler _dragHandler;
    private PText _valueNode;
    private Color _valueColor;
    private NumberFormat _valueFormat;

    public AbstractDragHandle(int n) {
        this(n, 3);
    }

    public AbstractDragHandle(int n, int n2) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("invalid orientation: " + n);
        }
        this._orientation = n;
        if (n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("invalid look: " + n2);
        }
        this._look = n2;
        Shape shape = null;
        shape = this._look == 2 ? AbstractDragHandle.getControlPointShape(n) : AbstractDragHandle.getArrowShape(n);
        this.setPathTo(shape);
        this.setPaint(QTConstants.DRAG_HANDLE_FILL_COLOR);
        this.setStroke(QTConstants.DRAG_HANDLE_STROKE);
        this.setStrokePaint(QTConstants.DRAG_HANDLE_STROKE_COLOR);
        this._registrationPoint = new Point2D.Double(this.getWidth() / 2.0, this.getHeight() / 2.0);
        this.translate(-this._registrationPoint.getX(), -this._registrationPoint.getY());
        if (this._look == 2) {
            Cursor cursor = AbstractDragHandle.getArrowCursor(n);
            this.addInputEventListener(new CursorHandler(cursor));
        } else {
            this.addInputEventListener(new CursorHandler());
        }
        this._dragHandler = new ConstrainedDragHandler();
        this.addInputEventListener(this._dragHandler);
        this._dragHandler.setTreatAsPointEnabled(true);
        this._dragHandler.setUseFullBounds(false);
        this._dragHandler.setNodeCenter(this._registrationPoint.getX(), this._registrationPoint.getY());
        if (n == 0) {
            this._dragHandler.setVerticalLockEnabled(true);
        } else {
            this._dragHandler.setHorizontalLockEnabled(true);
        }
        this._valueNode = null;
        this._valueColor = Color.BLACK;
        this._valueFormat = DEFAULT_VALUE_FORMAT;
    }

    public void setValueColor(Color color) {
        this._valueColor = color;
        if (this._valueNode != null) {
            this._valueNode.setTextPaint(color);
        }
    }

    public void setValueVisible(boolean bl) {
        if (bl && this._valueNode == null) {
            this._valueNode = new PText();
            this.addChild(this._valueNode);
            this._valueNode.setPickable(false);
            this._valueNode.setFont(QTConstants.DRAG_HANDLE_FONT);
            this._valueNode.setTextPaint(this._valueColor);
            this._valueNode.setText("0.0");
            PBounds pBounds = this.getBounds();
            double d = 0.0;
            double d2 = 0.0;
            if (this._look == 2) {
                d = ((RectangularShape)pBounds).getX() + ((RectangularShape)pBounds).getWidth() + 3.0;
                d2 = ((RectangularShape)pBounds).getY() - this._valueNode.getHeight();
            } else {
                d = ((RectangularShape)pBounds).getX() + ((RectangularShape)pBounds).getWidth();
                d2 = ((RectangularShape)pBounds).getY() - this._valueNode.getHeight() + 3.0;
            }
            this._valueNode.translate(d, d2);
            this.updateText();
        } else if (!bl && this._valueNode != null) {
            this.removeChild(this._valueNode);
            this._valueNode = null;
        }
    }

    public void setValueFormat(String string) {
        this._valueFormat = new DecimalFormat(string);
        this.updateText();
    }

    public void setDragBounds(Rectangle2D rectangle2D) {
        this._dragHandler.setDragBounds(rectangle2D);
    }

    public void setGlobalPosition(Point2D point2D) {
        Point2D point2D2 = this.getGlobalPosition();
        double d = point2D.getX() - point2D2.getX();
        double d2 = point2D.getY() - point2D2.getY();
        this.translate(d, d2);
    }

    public Point2D getGlobalPosition() {
        PBounds pBounds = this.getGlobalBounds();
        double d = ((RectangularShape)pBounds).getX() + this._registrationPoint.getX();
        double d2 = ((RectangularShape)pBounds).getY() + this._registrationPoint.getY();
        return new Point2D.Double(d, d2);
    }

    protected abstract double getModelValue();

    protected abstract void updateModel();

    protected void updateText() {
        if (this._valueNode != null) {
            double d = this.getModelValue();
            String string = this._valueFormat.format(d);
            this._valueNode.setText(string);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this && propertyChangeEvent.getPropertyName().equals("transform")) {
            this.updateModel();
            this.updateText();
        }
    }

    private static Shape getControlPointShape(int n) {
        return new Rectangle2D.Double(0.0, 0.0, 7.0, 7.0);
    }

    private static Shape getArrowShape(int n) {
        return AbstractDragHandle.getArrowShape(n, 24.0f);
    }

    private static Shape getArrowShape(int n, float f) {
        Shape shape = null;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(0.25f * f, 0.33f * f);
        generalPath.lineTo(0.08f * f, 0.33f * f);
        generalPath.lineTo(0.08f * f, 0.67f * f);
        generalPath.lineTo(0.25f * f, 0.67f * f);
        generalPath.lineTo(0.0f * f, 1.0f * f);
        generalPath.lineTo(-0.25f * f, 0.67f * f);
        generalPath.lineTo(-0.08f * f, 0.67f * f);
        generalPath.lineTo(-0.08f * f, 0.33f * f);
        generalPath.lineTo(-0.25f * f, 0.33f * f);
        generalPath.closePath();
        if (n == 1) {
            shape = generalPath;
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(Math.toRadians(90.0));
            shape = affineTransform.createTransformedShape(generalPath);
        }
        return shape;
    }

    private static Cursor getArrowCursor(int n) {
        Shape shape = AbstractDragHandle.getArrowShape(n, 18.0f);
        Rectangle rectangle = shape.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.fill(shape);
        Point point = new Point(bufferedImage.getWidth() / 2, bufferedImage.getHeight() / 2);
        String string = "DragHandleCursor";
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, point, string);
        return cursor;
    }
}

