/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.color;

import edu.colorado.phet.quantumtunneling.QTResources;
import edu.colorado.phet.quantumtunneling.color.BlackColorScheme;
import edu.colorado.phet.quantumtunneling.color.ColorSchemeDialog;
import edu.colorado.phet.quantumtunneling.color.QTColorScheme;
import edu.colorado.phet.quantumtunneling.color.WhiteColorScheme;
import edu.colorado.phet.quantumtunneling.module.QTModule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class QTColorSchemeMenu
extends JMenu {
    private QTModule _module;
    private QTColorScheme _presetColorScheme;
    private QTColorScheme _customColorScheme;
    private JDialog _customDialog;
    private JRadioButtonMenuItem _blackItem;
    private JRadioButtonMenuItem _whiteItem;
    private JRadioButtonMenuItem _customItem;

    public QTColorSchemeMenu(QTModule qTModule) {
        super(QTResources.getString("menu.colorScheme"));
        this.setMnemonic(QTResources.getString("menu.colorScheme.mnemonic").charAt(0));
        this._module = qTModule;
        this._blackItem = new JRadioButtonMenuItem(QTResources.getString("menu.colorScheme.black"));
        this._blackItem.setMnemonic(QTResources.getChar("menu.colorScheme.black.mnemonic", 'B'));
        this._blackItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QTColorSchemeMenu.this.handleBlackSelection();
            }
        });
        this._whiteItem = new JRadioButtonMenuItem(QTResources.getString("menu.colorScheme.white"));
        this._whiteItem.setMnemonic(QTResources.getChar("menu.colorScheme.white.mnemonic", 'W'));
        this._whiteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QTColorSchemeMenu.this.handleWhiteSelection();
            }
        });
        this._customItem = new JRadioButtonMenuItem(QTResources.getString("menu.colorScheme.custom"));
        this._customItem.setMnemonic(QTResources.getChar("menu.colorScheme.custom.mnemonic", 'C'));
        this._customItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QTColorSchemeMenu.this.handleCustomSelection();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._blackItem);
        buttonGroup.add(this._whiteItem);
        buttonGroup.add(this._customItem);
        this.add(this._blackItem);
        this.add(this._whiteItem);
        this.add(this._customItem);
        this.selectBlack();
    }

    public void selectBlack() {
        this._blackItem.setSelected(true);
        this.handleBlackSelection();
    }

    public void selectWhite() {
        this._whiteItem.setSelected(true);
        this.handleWhiteSelection();
    }

    public void setColorScheme(String string, QTColorScheme qTColorScheme) {
        this.closeDialog();
        if (string.equals("black")) {
            this.selectBlack();
        } else if (string.equals("white")) {
            this.selectWhite();
        } else {
            this._customItem.setSelected(true);
            this._customColorScheme = new QTColorScheme(qTColorScheme);
            this._module.setColorScheme(this._customColorScheme);
        }
    }

    public QTColorScheme getColorScheme() {
        if (this._customItem.isSelected()) {
            return this._customColorScheme;
        }
        return this._presetColorScheme;
    }

    public String getColorSchemeName() {
        String string = null;
        if (this._blackItem.isSelected()) {
            string = "black";
        } else if (this._whiteItem.isSelected()) {
            string = "white";
        } else if (this._customItem.isSelected()) {
            string = "custom";
        }
        return string;
    }

    private void handleBlackSelection() {
        this.closeDialog();
        this._presetColorScheme = new BlackColorScheme();
        this._module.setColorScheme(this._presetColorScheme);
    }

    private void handleWhiteSelection() {
        this.closeDialog();
        this._presetColorScheme = new WhiteColorScheme();
        this._module.setColorScheme(this._presetColorScheme);
    }

    private void handleCustomSelection() {
        this.closeDialog();
        if (this._customColorScheme == null) {
            this._customColorScheme = new QTColorScheme(this._presetColorScheme);
        }
        this._module.setColorScheme(this._customColorScheme);
        this._customDialog = new ColorSchemeDialog(this._module, this._customColorScheme);
        this._customDialog.show();
    }

    private void closeDialog() {
        if (this._customDialog != null) {
            this._customDialog.dispose();
            this._customDialog = null;
        }
    }
}

