/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.util.HashMap;
import java.util.Map;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import net.java.games.input.Rumbler;

public abstract class AbstractController
implements Controller {
    private static final Event event = new Event();
    private final String name;
    private final Component[] components;
    private final Controller[] children;
    private final Rumbler[] rumblers;
    private final Map id_to_components = new HashMap();
    private EventQueue event_queue = new EventQueue(32);

    protected AbstractController(String name, Component[] components, Controller[] children, Rumbler[] rumblers) {
        this.name = name;
        this.components = components;
        this.children = children;
        this.rumblers = rumblers;
        for (int i = components.length - 1; i >= 0; --i) {
            this.id_to_components.put(components[i].getIdentifier(), components[i]);
        }
    }

    public final Controller[] getControllers() {
        return this.children;
    }

    public final Component[] getComponents() {
        return this.components;
    }

    public final Component getComponent(Component.Identifier id) {
        return (Component)this.id_to_components.get(id);
    }

    public final Rumbler[] getRumblers() {
        return this.rumblers;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

