/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view.labels;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.ThreadedPlanarPiccoloNode;
import edu.colorado.phet.platetectonics.PlateTectonicsConstants;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.labels.TextLabel;
import edu.colorado.phet.platetectonics.view.ColorMode;
import edu.colorado.phet.platetectonics.view.labels.BaseLabelNode;
import edu.umd.cs.piccolo.nodes.PText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextLabelNode
extends BaseLabelNode {
    private TextLabel textLabel;
    private LWJGLTransform modelViewTransform;
    private final Property<ColorMode> colorMode;
    private final Property<Float> scale;
    private ThreadedPlanarPiccoloNode labelNode;

    public TextLabelNode(TextLabel textLabel, LWJGLTransform lWJGLTransform, final Property<ColorMode> property, Property<Float> property2) {
        super(property, true);
        this.textLabel = textLabel;
        this.modelViewTransform = lWJGLTransform;
        this.colorMode = property;
        this.scale = property2;
        this.requireDisabled(2929);
        this.requireEnabled(3042);
        this.labelNode = new ThreadedPlanarPiccoloNode(new PText(textLabel.label){
            {
                super(string);
                this.setFont(PlateTectonicsConstants.LABEL_FONT);
                this.scale(3.0);
                property.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setTextPaint(TextLabelNode.this.getColor());
                        this.repaint();
                    }
                });
            }
        });
        this.addChild(this.labelNode);
        property.addObserver(new SimpleObserver(){

            public void update() {
                TextLabelNode.this.labelNode.repaint();
            }
        });
    }

    @Override
    public void renderSelf(GLOptions gLOptions) {
        super.renderSelf(gLOptions);
        Vector3F vector3F = this.modelViewTransform.transformPosition(PlateTectonicsModel.convertToRadial(this.textLabel.centerPosition.get()));
        this.labelNode.transform.set(Matrix4F.translation(vector3F.x, vector3F.y, vector3F.z));
        this.labelNode.transform.append(Matrix4F.scaling(0.14999999f * this.scale.get().floatValue()));
        this.labelNode.transform.append(Matrix4F.translation(-this.labelNode.getComponentWidth() / 2, -this.labelNode.getComponentHeight() / 2, 0.0f));
    }
}

