/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view.labels;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.ValueNotifier;
import edu.colorado.phet.common.phetcommon.model.event.VoidNotifier;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.nodes.ThreadedPlanarPiccoloNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.platetectonics.PlateTectonicsConstants;
import edu.colorado.phet.platetectonics.model.labels.RangeLabel;
import edu.colorado.phet.platetectonics.util.MortalSimpleObserver;
import edu.colorado.phet.platetectonics.view.ColorMode;
import edu.colorado.phet.platetectonics.view.labels.BaseLabelNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.geom.AffineTransform;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeLabelNode
extends BaseLabelNode {
    public static final Vector3F NORMAL = Vector3F.Z_UNIT;
    private final Property<Vector3F> top;
    private final Property<Vector3F> bottom;
    private final String label;
    private Property<Vector3F> labelLocation;
    private ThreadedPlanarPiccoloNode labelNode;
    private GLNode labelNodeContainer;
    private Property<Float> scale;
    private PText labelPNode;
    private boolean shouldRotate = true;
    private final RangeLabel rangeLabel;

    public RangeLabelNode(RangeLabel rangeLabel, final Property<Vector3F> property, final Property<Vector3F> property2, String string, Property<Float> property3, Property<ColorMode> property4, boolean bl) {
        this(rangeLabel, property, property2, string, property3, property4, bl, new Property<Vector3F>(property.get().plus(property2.get()).times(0.5f)){
            {
                super(vector3F);
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        this.set(((Vector3F)property.get()).plus((AbstractVector3F)property2.get()).times(0.5f));
                    }
                };
                property.addObserver(simpleObserver);
                property2.addObserver(simpleObserver);
            }
        });
    }

    public RangeLabelNode(RangeLabel rangeLabel, final Property<Vector3F> property, final Property<Vector3F> property2, String string, Property<Float> property3, final Property<ColorMode> property4, boolean bl, Property<Vector3F> property5) {
        super(property4, bl);
        this.top = property;
        this.bottom = property2;
        this.label = string;
        this.labelLocation = property5;
        this.scale = property3;
        this.rangeLabel = rangeLabel;
        final ValueNotifier valueNotifier = rangeLabel == null ? new VoidNotifier() : rangeLabel.disposed;
        this.labelPNode = new PText(string){
            {
                super(string);
                this.setFont(PlateTectonicsConstants.LABEL_FONT);
                this.scale(3.0);
                property4.addObserver(new MortalSimpleObserver(property4, valueNotifier){

                    public void update() {
                        this.setTextPaint(RangeLabelNode.this.getColor());
                        this.repaint();
                    }
                });
            }
        };
        this.labelNode = new ThreadedPlanarPiccoloNode(new PNode(){
            {
                this.addChild(RangeLabelNode.this.labelPNode);
                final 3 var4_4 = this;
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        this.setTransform(new AffineTransform());
                        if (RangeLabelNode.this.shouldRotate) {
                            this.rotateAboutPoint(((Vector3F)property.get()).minus((AbstractVector3F)property2.get()).angleBetween(new Vector3F(0.0f, 1.0f, 0.0f)) * (float)(((Vector3F)property.get()).x > ((Vector3F)property2.get()).x ? 1 : -1), RangeLabelNode.this.labelPNode.getFullBounds().getWidth() / 2.0, RangeLabelNode.this.labelPNode.getFullBounds().getHeight() / 2.0);
                        }
                        ZeroOffsetNode.zeroNodeOffset(var4_4);
                    }
                };
                property.addObserver(simpleObserver);
                property2.addObserver(simpleObserver);
            }
        }){
            {
                super(pNode);
                final 4 var7_7 = this;
                property4.addObserver(new MortalSimpleObserver(property4, valueNotifier){

                    public void update() {
                        var7_7.repaint();
                    }
                });
                property.addObserver(new SimpleObserver(){

                    public void update() {
                        var7_7.repaint();
                    }
                });
                property2.addObserver(new SimpleObserver(){

                    public void update() {
                        var7_7.repaint();
                    }
                });
            }
        };
        this.labelNodeContainer = new GLNode();
        this.labelNodeContainer.addChild(this.labelNode);
        this.addChild(this.labelNodeContainer);
        this.requireDisabled(2929);
        this.requireEnabled(3042);
    }

    @Override
    public void renderSelf(GLOptions gLOptions) {
        boolean bl;
        super.renderSelf(gLOptions);
        Vector3F vector3F = this.bottom.get().minus(this.top.get()).normalized();
        Vector3F vector3F2 = vector3F.cross(NORMAL).normalized();
        Vector3F vector3F3 = vector3F2.times(this.scale.get().floatValue() * 7.0f / 2.0f);
        Vector3F vector3F4 = this.labelLocation.get();
        float f = (float)(this.labelPNode.getFullBounds().getHeight() / 2.0 * 0.14999999105930328 * (double)1.3f * (double)this.scale.get().floatValue());
        Vector3F vector3F5 = vector3F4.minus(vector3F.times(f));
        Vector3F vector3F6 = vector3F4.plus(vector3F.times(f));
        this.shouldRotate = bl = vector3F5.minus(this.top.get()).dot(vector3F) >= 0.0f;
        this.labelNode.transform.set(Matrix4F.translation(this.labelLocation.get().x, this.labelLocation.get().y, this.labelLocation.get().z));
        this.labelNode.transform.append(Matrix4F.scaling(0.14999999f * this.scale.get().floatValue()));
        this.labelNode.transform.append(Matrix4F.translation(-this.labelNode.getComponentWidth() / 2, -this.labelNode.getComponentHeight() / 2, 0.0f));
        if (bl) {
            this.labelNodeContainer.transform.set(Matrix4F.IDENTITY);
            GL11.glBegin(1);
            LWJGLUtils.color4f(this.getColor());
            LWJGLUtils.vertex3f(this.top.get().plus(vector3F3));
            LWJGLUtils.vertex3f(this.top.get().minus(vector3F3));
            LWJGLUtils.vertex3f(this.bottom.get().plus(vector3F3));
            LWJGLUtils.vertex3f(this.bottom.get().minus(vector3F3));
            LWJGLUtils.vertex3f(this.top.get());
            LWJGLUtils.vertex3f(vector3F5);
            LWJGLUtils.vertex3f(vector3F6);
            LWJGLUtils.vertex3f(this.bottom.get());
            GL11.glEnd();
        } else {
            float f2 = (float)(this.labelPNode.getFullBounds().getWidth() / 2.0) * 0.14999999f * 1.1f * this.scale.get().floatValue();
            this.labelNodeContainer.transform.set(Matrix4F.translation(30.0f * this.scale.get().floatValue() + f2, 10.0f * this.scale.get().floatValue(), 0.0f));
            GL11.glBegin(3);
            LWJGLUtils.color4f(this.getColor());
            LWJGLUtils.vertex3f(vector3F4);
            LWJGLUtils.vertex3f(vector3F4.plus(new Vector3F(10.0f, 10.0f, 0.0f).times(this.scale.get().floatValue())));
            LWJGLUtils.vertex3f(vector3F4.plus(new Vector3F(30.0f, 10.0f, 0.0f).times(this.scale.get().floatValue())));
            GL11.glEnd();
        }
    }
}

