/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view.labels;

import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.labels.BoundaryLabel;
import edu.colorado.phet.platetectonics.util.Side;
import edu.colorado.phet.platetectonics.view.ColorMode;
import edu.colorado.phet.platetectonics.view.labels.BaseLabelNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundaryLabelNode
extends BaseLabelNode {
    private BoundaryLabel boundaryLabel;
    private LWJGLTransform modelViewTransform;

    public BoundaryLabelNode(BoundaryLabel boundaryLabel, LWJGLTransform lWJGLTransform, Property<ColorMode> property) {
        super(property, true);
        this.boundaryLabel = boundaryLabel;
        this.modelViewTransform = lWJGLTransform;
        this.requireDisabled(2929);
        this.requireEnabled(3042);
    }

    @Override
    public void renderSelf(GLOptions gLOptions) {
        super.renderSelf(gLOptions);
        List<Sample> list = this.boundaryLabel.boundary.samples;
        if (this.boundaryLabel.side == Side.LEFT != this.boundaryLabel.isReversed()) {
            list = new ArrayList<Sample>(list);
            Collections.reverse(list);
        }
        GL11.glEnable(2852);
        GL11.glLineStipple(1, (short)-256);
        GL11.glBegin(3);
        LWJGLUtils.color4f(this.getColor());
        Sample sample = null;
        for (Sample sample2 : this.boundaryLabel.boundary.samples) {
            Vector3F vector3F = sample2.getPosition();
            if (!(vector3F.getX() < this.boundaryLabel.minX.get().floatValue())) {
                float f;
                float f2;
                if (vector3F.getX() > this.boundaryLabel.maxX.get().floatValue()) {
                    f2 = sample.getPosition().getX();
                    f = (this.boundaryLabel.maxX.get().floatValue() - f2) / (vector3F.getX() - f2);
                    LWJGLUtils.vertex3f(this.modelViewTransform.transformPosition(PlateTectonicsModel.convertToRadial(vector3F.times(f).plus(sample.getPosition().times(1.0f - f)))));
                } else {
                    if (sample != null && sample.getPosition().getX() < this.boundaryLabel.minX.get().floatValue()) {
                        f2 = sample.getPosition().getX();
                        f = (this.boundaryLabel.minX.get().floatValue() - f2) / (vector3F.getX() - f2);
                        LWJGLUtils.vertex3f(this.modelViewTransform.transformPosition(PlateTectonicsModel.convertToRadial(vector3F.times(f).plus(sample.getPosition().times(1.0f - f)))));
                    }
                    LWJGLUtils.vertex3f(this.modelViewTransform.transformPosition(PlateTectonicsModel.convertToRadial(vector3F)));
                }
            }
            sample = sample2;
        }
        GL11.glEnd();
        GL11.glDisable(2852);
        GL11.glLineWidth(1.0f);
    }

    public BoundaryLabel getBoundaryLabel() {
        return this.boundaryLabel;
    }
}

