/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view;

import edu.colorado.phet.common.phetcommon.math.Bounds3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxHighlightNode
extends GLNode {
    public final Bounds3F bounds;
    private LWJGLTransform modelViewTransform;
    private Property<Color> color;

    public BoxHighlightNode(Bounds3F bounds3F, LWJGLTransform lWJGLTransform, Property<Color> property) {
        this.bounds = bounds3F;
        this.modelViewTransform = lWJGLTransform;
        this.color = property;
        this.requireEnabled(3042);
    }

    private Vector3F transformPoint(Vector3F vector3F) {
        return this.modelViewTransform.transformPosition(PlateTectonicsModel.convertToRadial(vector3F));
    }

    private Vector3F[] transformedLine(Vector3F vector3F, Vector3F vector3F2, int n) {
        Vector3F[] vector3FArray = new Vector3F[n];
        for (int i = 0; i < n; ++i) {
            float f = (float)i / (float)(n - 1);
            vector3FArray[i] = this.transformPoint(vector3F.times(1.0f - f).plus(vector3F2.times(f)));
        }
        return vector3FArray;
    }

    private void drawFromTo(Vector3F vector3F, Vector3F vector3F2, int n) {
        for (Vector3F vector3F3 : this.transformedLine(vector3F, vector3F2, n)) {
            LWJGLUtils.vertex3f(vector3F3);
        }
    }

    private void quadLine(Vector3F[] vector3FArray, Vector3F[] vector3FArray2) {
        GL11.glBegin(5);
        for (int i = 0; i < vector3FArray.length; ++i) {
            LWJGLUtils.vertex3f(vector3FArray[i]);
            LWJGLUtils.vertex3f(vector3FArray2[i]);
        }
        GL11.glEnd();
    }

    @Override
    public void renderSelf(GLOptions gLOptions) {
        super.renderSelf(gLOptions);
        Vector3F vector3F = new Vector3F(this.bounds.getMinX(), this.bounds.getMinY(), this.bounds.getMinZ());
        Vector3F vector3F2 = new Vector3F(this.bounds.getMinX(), this.bounds.getMinY(), this.bounds.getMaxZ());
        Vector3F vector3F3 = new Vector3F(this.bounds.getMinX(), this.bounds.getMaxY(), this.bounds.getMinZ());
        Vector3F vector3F4 = new Vector3F(this.bounds.getMinX(), this.bounds.getMaxY(), this.bounds.getMaxZ());
        Vector3F vector3F5 = new Vector3F(this.bounds.getMaxX(), this.bounds.getMinY(), this.bounds.getMinZ());
        Vector3F vector3F6 = new Vector3F(this.bounds.getMaxX(), this.bounds.getMinY(), this.bounds.getMaxZ());
        Vector3F vector3F7 = new Vector3F(this.bounds.getMaxX(), this.bounds.getMaxY(), this.bounds.getMinZ());
        Vector3F vector3F8 = new Vector3F(this.bounds.getMaxX(), this.bounds.getMaxY(), this.bounds.getMaxZ());
        int n = 10;
        int n2 = 20;
        GL11.glEnable(2852);
        GL11.glLineStipple(1, (short)-256);
        LWJGLUtils.color4f(this.color.get());
        this.quadLine(this.transformedLine(vector3F4, vector3F8, n2), this.transformedLine(vector3F2, vector3F6, n2));
        for (int i = 0; i < n - 1; ++i) {
            float f = (float)i / (float)(n - 1);
            float f2 = (float)(i + 1) / (float)(n - 1);
            this.quadLine(this.transformedLine(vector3F3.times(f).plus(vector3F4.times(1.0f - f)), vector3F7.times(f).plus(vector3F8.times(1.0f - f)), n2), this.transformedLine(vector3F3.times(f2).plus(vector3F4.times(1.0f - f2)), vector3F7.times(f2).plus(vector3F8.times(1.0f - f2)), n2));
        }
        GL11.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glBegin(3);
        this.drawFromTo(vector3F, vector3F3, 2);
        this.drawFromTo(vector3F3, vector3F7, n2);
        this.drawFromTo(vector3F7, vector3F5, 2);
        this.drawFromTo(vector3F5, vector3F, n2);
        GL11.glEnd();
        GL11.glBegin(3);
        this.drawFromTo(vector3F2, vector3F4, 2);
        this.drawFromTo(vector3F4, vector3F8, n2);
        this.drawFromTo(vector3F8, vector3F6, 2);
        this.drawFromTo(vector3F6, vector3F2, n2);
        GL11.glEnd();
        GL11.glBegin(3);
        this.drawFromTo(vector3F, vector3F2, n);
        GL11.glEnd();
        GL11.glBegin(3);
        this.drawFromTo(vector3F3, vector3F4, n);
        GL11.glEnd();
        GL11.glBegin(3);
        this.drawFromTo(vector3F5, vector3F6, n);
        GL11.glEnd();
        GL11.glBegin(3);
        this.drawFromTo(vector3F7, vector3F8, n);
        GL11.glEnd();
        GL11.glDisable(2852);
        GL11.glLineWidth(1.0f);
    }
}

