/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.tabs;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.PlaneF;
import edu.colorado.phet.common.phetcommon.math.Ray3F;
import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.common.phetcommon.model.event.VoidNotifier;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.lwjglphet.CanvasTransform;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import edu.colorado.phet.lwjglphet.LWJGLTab;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.nodes.GuiNode;
import edu.colorado.phet.lwjglphet.nodes.OrthoPiccoloNode;
import edu.colorado.phet.lwjglphet.nodes.OrthoSwingNode;
import edu.colorado.phet.lwjglphet.nodes.ThreadedPlanarPiccoloNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.platetectonics.PlateTectonicsApplication;
import edu.colorado.phet.platetectonics.PlateTectonicsConstants;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import edu.colorado.phet.platetectonics.control.CrustPieceNode;
import edu.colorado.phet.platetectonics.control.DensitySensorNode3D;
import edu.colorado.phet.platetectonics.control.DraggableTool2D;
import edu.colorado.phet.platetectonics.control.RulerNode3D;
import edu.colorado.phet.platetectonics.control.ThermometerNode3D;
import edu.colorado.phet.platetectonics.control.ToolDragHandler;
import edu.colorado.phet.platetectonics.control.ToolboxNode;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.TectonicsClock;
import edu.colorado.phet.platetectonics.model.ToolboxState;
import edu.colorado.phet.platetectonics.view.ColorMode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlateTectonicsTab
extends LWJGLTab {
    public final Property<ColorMode> colorMode = new Property<ColorMode>(ColorMode.DENSITY);
    public final Property<Double> zoomRatio = new Property<Double>(1.0);
    public final LWJGLTransform sceneProjectionTransform = new LWJGLTransform();
    public final LWJGLTransform sceneModelViewTransform = new LWJGLTransform();
    private Dimension stageSize;
    public final VoidNotifier mouseEventNotifier = new VoidNotifier();
    public final VoidNotifier keyboardEventNotifier = new VoidNotifier();
    public final VoidNotifier beforeFrameRender = new VoidNotifier();
    public final VoidNotifier timeChangeNotifier = new VoidNotifier();
    private LWJGLTransform debugCameraTransform = new LWJGLTransform();
    protected CanvasTransform canvasTransform;
    private LWJGLTransform modelViewTransform;
    private long lastSeenTime;
    public final GLNode rootNode = new GLNode();
    protected GLNode sceneLayer;
    protected GLNode guiLayer;
    protected GLNode toolLayer;
    private boolean showWireframe = false;
    private PlateTectonicsModel model;
    protected final List<OrthoSwingNode> guiNodes = new ArrayList<OrthoSwingNode>();
    protected ToolboxState toolboxState = new ToolboxState();
    protected ToolDragHandler toolDragHandler = new ToolDragHandler(this.toolboxState);
    protected ToolboxNode toolboxNode;
    protected OrthoPiccoloNode draggedCrustPiece = null;
    private final TectonicsClock clock = new TectonicsClock(1.0);
    private float timeElapsed;
    public final Property<Double> framesPerSecond = new Property<Double>(0.0);
    private final LinkedList<Long> timeQueue = new LinkedList();
    private boolean initialized = false;
    private FloatBuffer specular = LWJGLUtils.floatBuffer(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
    private FloatBuffer shininess = LWJGLUtils.floatBuffer(new float[]{50.0f});
    private FloatBuffer sunDirection = LWJGLUtils.floatBuffer(new float[]{1.0f, 3.0f, 2.0f, 0.0f});
    private FloatBuffer moonDirection = LWJGLUtils.floatBuffer(new float[]{-2.0f, 1.0f, -1.0f, 0.0f});

    public PlateTectonicsTab(LWJGLCanvas lWJGLCanvas, String string, float f) {
        super(lWJGLCanvas, string);
        this.modelViewTransform = new LWJGLTransform(Matrix4F.scaling(f / 1000.0f));
    }

    public void initialize() {
        if (this.initialCanvasSize == null) {
            this.initialCanvasSize = this.getCanvas().getSize();
        }
        this.stageSize = this.initialCanvasSize;
        if (Math.abs(this.stageSize.getWidth() - 1008.0) > 20.0 || Math.abs(this.stageSize.getHeight() - 676.0) > 20.0) {
            this.stageSize = new Dimension(1008, 676);
        }
        this.canvasTransform = new CanvasTransform.StageCenteringCanvasTransform(this.canvasSize, this.stageSize);
        this.clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                if (PlateTectonicsTab.this.getModel() != null) {
                    double d = clockEvent.getSimulationTimeChange();
                    PlateTectonicsTab.this.getModel().update(d);
                }
            }
        });
        GL11.glPolygonMode(1028, 6914);
        GL11.glPolygonMode(1029, 6914);
        GL11.glBlendFunc(770, 771);
        this.sceneLayer = new GLNode(){
            {
                this.requireEnabled(2929);
            }

            protected void preRender(GLOptions gLOptions) {
                super.preRender(gLOptions);
                PlateTectonicsTab.this.loadCameraMatrices();
                PlateTectonicsTab.this.loadLighting();
            }
        };
        this.guiLayer = new GuiNode(this);
        this.toolLayer = new GLNode(){
            {
                this.requireEnabled(3042);
            }

            protected void preRender(GLOptions gLOptions) {
                super.preRender(gLOptions);
                PlateTectonicsTab.this.loadCameraMatrices();
            }
        };
        this.rootNode.addChild(this.sceneLayer);
        this.rootNode.addChild(this.guiLayer);
        this.rootNode.addChild(this.toolLayer);
        this.mouseEventNotifier.addUpdateListener(new UpdateListener(){

            public void update() {
                if (Keyboard.isKeyDown(16)) {
                    int n = Mouse.getEventDX();
                    if (Mouse.isButtonDown(0)) {
                        int n2 = Mouse.getEventDY();
                        PlateTectonicsTab.this.debugCameraTransform.prepend(Matrix4F.rotationY((float)n / 100.0f));
                        PlateTectonicsTab.this.debugCameraTransform.prepend(Matrix4F.rotationX((float)(-n2) / 100.0f));
                    } else if (Mouse.isButtonDown(1)) {
                        PlateTectonicsTab.this.debugCameraTransform.prepend(Matrix4F.rotationZ((float)n / 100.0f));
                    }
                }
            }
        }, false);
        this.keyboardEventNotifier.addUpdateListener(new UpdateListener(){

            public void update() {
                if (Keyboard.getEventKey() == 33) {
                    PlateTectonicsTab.this.showWireframe = Keyboard.getEventKeyState();
                }
            }
        }, false);
        this.beforeFrameRender.addUpdateListener(new UpdateListener(){

            public void update() {
                if (Keyboard.isKeyDown(17)) {
                    PlateTectonicsTab.this.debugCameraTransform.prepend(Matrix4F.translation(0.0f, 0.0f, 1.0f));
                }
                if (Keyboard.isKeyDown(31)) {
                    PlateTectonicsTab.this.debugCameraTransform.prepend(Matrix4F.translation(0.0f, 0.0f, -1.0f));
                }
                if (Keyboard.isKeyDown(30)) {
                    PlateTectonicsTab.this.debugCameraTransform.prepend(Matrix4F.translation(1.0f, 0.0f, 0.0f));
                }
                if (Keyboard.isKeyDown(32)) {
                    PlateTectonicsTab.this.debugCameraTransform.prepend(Matrix4F.translation(-1.0f, 0.0f, 0.0f));
                }
            }
        }, false);
        this.mouseEventNotifier.addUpdateListener(new UpdateListener(){

            public void update() {
                PlateTectonicsTab.this.updateCursor();
                if (Mouse.getEventButton() == -1) {
                    if (PlateTectonicsTab.this.draggedCrustPiece != null) {
                        float f = (float)PlateTectonicsTab.this.getCanvasTransform().transform.get().getScaleX();
                        PlateTectonicsTab.this.draggedCrustPiece.position.set(((Vector2D)PlateTectonicsTab.this.draggedCrustPiece.position.get()).plus(new Vector2D((float)Mouse.getEventDX() / f, (float)(-Mouse.getEventDY()) / f)));
                        PlateTectonicsTab.this.movedCrustPiece(PlateTectonicsTab.this.draggedCrustPiece);
                    } else {
                        PlateTectonicsTab.this.toolDragHandler.mouseMove(PlateTectonicsTab.this.getMouseViewPositionOnZPlane());
                    }
                }
            }
        }, false);
        this.mouseEventNotifier.addUpdateListener(new UpdateListener(){

            public void update() {
                if (Mouse.getEventButton() == 0) {
                    ThreadedPlanarPiccoloNode threadedPlanarPiccoloNode = PlateTectonicsTab.this.getToolUnder(Mouse.getEventX(), Mouse.getEventY());
                    OrthoSwingNode orthoSwingNode = PlateTectonicsTab.this.getGuiUnder(Mouse.getEventX(), Mouse.getEventY());
                    if (Mouse.getEventButtonState()) {
                        if (orthoSwingNode instanceof OrthoPiccoloNode && ((OrthoPiccoloNode)orthoSwingNode).getNode() instanceof CrustPieceNode) {
                            PlateTectonicsTab.this.draggedCrustPiece = (OrthoPiccoloNode)orthoSwingNode;
                            PlateTectonicsTab.this.pickedCrustPiece(PlateTectonicsTab.this.draggedCrustPiece);
                        } else if (threadedPlanarPiccoloNode != null) {
                            PlateTectonicsTab.this.toolDragHandler.mouseDownOnTool((DraggableTool2D)((Object)threadedPlanarPiccoloNode), PlateTectonicsTab.this.getMouseViewPositionOnZPlane());
                        } else if (orthoSwingNode == null) {
                            PlateTectonicsTab.this.uncaughtMouseButton();
                        }
                    } else if (PlateTectonicsTab.this.draggedCrustPiece != null) {
                        PlateTectonicsTab.this.droppedCrustPiece(PlateTectonicsTab.this.draggedCrustPiece);
                        PlateTectonicsTab.this.draggedCrustPiece = null;
                    } else if (PlateTectonicsTab.this.toolDragHandler.isDragging()) {
                        boolean bl = orthoSwingNode != null && orthoSwingNode == PlateTectonicsTab.this.toolboxNode;
                        boolean bl2 = !PlateTectonicsTab.this.isToolInBounds(PlateTectonicsTab.this.toolDragHandler.getDraggedTool());
                        PlateTectonicsTab.this.toolDragHandler.mouseUp(bl || bl2);
                    } else {
                        PlateTectonicsTab.this.uncaughtMouseButton();
                    }
                }
            }
        }, false);
        this.toolboxNode = new ToolboxNode(this, this.toolboxState){
            {
                PlateTectonicsTab.this.canvasSize.addObserver(new SimpleObserver(){

                    public void update() {
                        position.set(new Vector2D(10.0, PlateTectonicsTab.this.getStageSize().height - this.getComponentHeight() - 10));
                    }
                });
                this.updateOnEvent(PlateTectonicsTab.this.beforeFrameRender);
            }
        };
        this.addGuiNode(this.toolboxNode);
        this.toolboxState.rulerInToolbox.addObserver(new SimpleObserver(){

            public void update() {
                if (!PlateTectonicsTab.this.toolboxState.rulerInToolbox.get().booleanValue()) {
                    SimSharingManager.sendUserMessage(PlateTectonicsSimSharing.UserComponents.ruler, UserComponentTypes.sprite, PlateTectonicsSimSharing.UserActions.removedFromToolbox);
                    RulerNode3D rulerNode3D = new RulerNode3D(PlateTectonicsTab.this.getModelViewTransform(), PlateTectonicsTab.this);
                    PlateTectonicsTab.this.toolLayer.addChild(rulerNode3D);
                    Vector2F vector2F = PlateTectonicsTab.this.getMouseViewPositionOnZPlane();
                    Vector2F vector2F2 = rulerNode3D.getInitialMouseOffset();
                    float f = vector2F.x - vector2F2.x;
                    float f2 = vector2F.y - vector2F2.y;
                    rulerNode3D.draggedPosition = new Vector2F(f, f2);
                    rulerNode3D.transform.prepend(Matrix4F.translation(f, f2, 0.0f));
                    PlateTectonicsTab.this.toolDragHandler.startDragging(rulerNode3D, vector2F);
                }
            }
        });
        this.toolboxState.thermometerInToolbox.addObserver(new SimpleObserver(){

            public void update() {
                if (!PlateTectonicsTab.this.toolboxState.thermometerInToolbox.get().booleanValue()) {
                    SimSharingManager.sendUserMessage(PlateTectonicsSimSharing.UserComponents.thermometer, UserComponentTypes.sprite, PlateTectonicsSimSharing.UserActions.removedFromToolbox);
                    ThermometerNode3D thermometerNode3D = new ThermometerNode3D(PlateTectonicsTab.this.getModelViewTransform(), PlateTectonicsTab.this, PlateTectonicsTab.this.model);
                    PlateTectonicsTab.this.toolLayer.addChild(thermometerNode3D);
                    Vector2F vector2F = PlateTectonicsTab.this.getMouseViewPositionOnZPlane();
                    Vector2F vector2F2 = thermometerNode3D.getInitialMouseOffset();
                    float f = vector2F.x - vector2F2.x;
                    float f2 = vector2F.y - vector2F2.y;
                    thermometerNode3D.draggedPosition = new Vector2F(f, f2);
                    thermometerNode3D.transform.prepend(Matrix4F.translation(f, f2, 1.0f));
                    PlateTectonicsTab.this.toolDragHandler.startDragging(thermometerNode3D, vector2F);
                }
            }
        });
        this.toolboxState.densitySensorInToolbox.addObserver(new SimpleObserver(){

            public void update() {
                if (!PlateTectonicsTab.this.toolboxState.densitySensorInToolbox.get().booleanValue()) {
                    SimSharingManager.sendUserMessage(PlateTectonicsSimSharing.UserComponents.densityMeter, UserComponentTypes.sprite, PlateTectonicsSimSharing.UserActions.removedFromToolbox);
                    DensitySensorNode3D densitySensorNode3D = new DensitySensorNode3D(PlateTectonicsTab.this.getModelViewTransform(), PlateTectonicsTab.this, PlateTectonicsTab.this.model);
                    PlateTectonicsTab.this.toolLayer.addChild(densitySensorNode3D);
                    Vector2F vector2F = PlateTectonicsTab.this.getMouseViewPositionOnZPlane();
                    Vector2F vector2F2 = densitySensorNode3D.getInitialMouseOffset();
                    float f = vector2F.x - vector2F2.x;
                    float f2 = vector2F.y - vector2F2.y;
                    densitySensorNode3D.draggedPosition = new Vector2F(f, f2);
                    densitySensorNode3D.transform.prepend(Matrix4F.translation(f, f2, 2.0f));
                    PlateTectonicsTab.this.toolDragHandler.startDragging(densitySensorNode3D, vector2F);
                }
            }
        });
    }

    public PlateTectonicsModel getModel() {
        return this.model;
    }

    protected void setModel(PlateTectonicsModel plateTectonicsModel) {
        this.model = plateTectonicsModel;
    }

    @Override
    public void start() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        this.lastSeenTime = System.currentTimeMillis();
    }

    public boolean allowClockTickOnFrame() {
        return true;
    }

    @Override
    public void loop() {
        long l;
        Display.sync(PlateTectonicsConstants.FRAMES_PER_SECOND_LIMIT.get());
        int n = 10;
        long l2 = System.currentTimeMillis();
        this.timeQueue.add(l2);
        if (this.timeQueue.size() == n + 1) {
            l = this.timeQueue.poll();
            this.framesPerSecond.set(Double.valueOf(1000.0f * (float)n / (float)(l2 - l)));
        }
        l = System.currentTimeMillis();
        this.timeElapsed = Math.min(1000.0f / (float)PlateTectonicsConstants.FRAMES_PER_SECOND_LIMIT.get().intValue(), (float)(l - this.lastSeenTime) / 1000.0f);
        this.lastSeenTime = l;
        this.timeChangeNotifier.updateListeners();
        if (this.allowClockTickOnFrame()) {
            this.clock.stepByWallSeconds(this.timeElapsed);
        }
        this.loadCameraMatrices();
        this.beforeFrameRender.updateListeners();
        GL11.glClearColor(0.85f, 0.95f, 1.0f, 1.0f);
        GL11.glClear(16640);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        while (Mouse.next()) {
            this.mouseEventNotifier.updateListeners();
        }
        while (Keyboard.next()) {
            this.keyboardEventNotifier.updateListeners();
        }
        GLOptions gLOptions = new GLOptions();
        if (this.showWireframe) {
            gLOptions.forWireframe = true;
            GL11.glPolygonMode(1032, 6913);
        } else {
            GL11.glPolygonMode(1032, 6914);
        }
        GL11.glViewport(0, 0, this.getCanvasWidth(), this.getCanvasHeight());
        this.setupGuiTransformations();
        gLOptions.renderPass = GLOptions.RenderPass.REGULAR;
        this.rootNode.render(gLOptions);
        gLOptions.renderPass = GLOptions.RenderPass.TRANSPARENCY;
        this.rootNode.render(gLOptions);
        Display.update();
    }

    @Override
    public void stop() {
    }

    public LWJGLTransform getModelViewTransform() {
        return this.modelViewTransform;
    }

    public CanvasTransform getCanvasTransform() {
        return this.canvasTransform;
    }

    public float getTimeElapsed() {
        return this.timeElapsed;
    }

    public Dimension getStageSize() {
        return this.stageSize;
    }

    public void loadCameraMatrices() {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        this.sceneProjectionTransform.set(this.getSceneProjectionMatrix());
        this.sceneProjectionTransform.apply();
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        this.sceneModelViewTransform.set(this.getSceneModelViewMatrix());
        this.sceneModelViewTransform.apply();
    }

    public Matrix4F getSceneProjectionMatrix() {
        float f = 0.34906584f;
        float f2 = (float)Math.atan((double)this.canvasTransform.getFieldOfViewYFactor() * Math.tan(f));
        Matrix4F matrix4F = this.getGluPerspective(f2, (float)((Dimension)this.canvasSize.get()).width / (float)((Dimension)this.canvasSize.get()).height, 1.0f, 21000.0f);
        return matrix4F;
    }

    public float getSceneDistanceZoomFactor() {
        float f = 1.0f;
        float f2 = 35.0f;
        return f + this.getEffectiveZoomRatio() * (f2 - f);
    }

    public Matrix4F getSceneModelViewMatrix() {
        float f = 13.0f;
        float f2 = 0.0f;
        float f3 = -80.0f;
        float f4 = this.modelViewTransform.transformDeltaY(3185500.0f);
        float f5 = -400.0f;
        float f6 = -18000.0f;
        float f7 = this.getEffectiveZoomRatio();
        float f8 = f + f7 * (f2 - f);
        return this.debugCameraTransform.getMatrix().times(Matrix4F.rotation(Vector3F.X_UNIT, f8 / 180.0f * (float)Math.PI)).times(Matrix4F.translation(0.0f, f3 + f7 * f7 * (f4 - f3), f5 + f7 * (f6 - f5)));
    }

    private float getEffectiveZoomRatio() {
        float f = 1.0f - this.zoomRatio.get().floatValue();
        return f * f;
    }

    public Matrix4F getGluPerspective(float f, float f2, float f3, float f4) {
        float f5 = (float)Math.cos(f) / (float)Math.sin(f);
        return Matrix4F.rowMajor(f5 / f2, 0.0f, 0.0f, 0.0f, 0.0f, f5, 0.0f, 0.0f, 0.0f, 0.0f, (f4 + f3) / (f3 - f4), 2.0f * f4 * f3 / (f3 - f4), 0.0f, 0.0f, -1.0f, 0.0f);
    }

    public Vector3F getCameraPosition() {
        return this.sceneModelViewTransform.getInverse().times(new Vector3F(0.0f, 0.0f, 0.0f));
    }

    public Ray3F getCameraRay(int n, int n2) {
        Vector3F vector3F = new Vector3F((float)(2 * n) / (float)this.getCanvasWidth() - 1.0f, (float)(2 * n2) / (float)this.getCanvasHeight() - 1.0f, 1.0f);
        Vector3F vector3F2 = this.sceneProjectionTransform.getInverse().times(vector3F);
        Vector3F vector3F3 = this.sceneModelViewTransform.getInverse().times(vector3F2);
        Vector3F vector3F4 = this.sceneModelViewTransform.getInverse().times(vector3F2.times(2.0f));
        Ray3F ray3F = new Ray3F(vector3F3, vector3F4.minus(vector3F3));
        return ray3F;
    }

    public void loadLighting() {
        GL11.glMaterial(1028, 4610, this.specular);
        GL11.glLight(16384, 4611, this.sunDirection);
        GL11.glLight(16385, 4611, this.moonDirection);
        GL11.glEnable(16384);
        GL11.glEnable(16385);
    }

    public OrthoSwingNode createFPSReadout(final Color color) {
        JPanel jPanel = new JPanel(){
            {
                this.setPreferredSize(new Dimension(100, 30));
                this.setOpaque(true);
                this.add(new JLabel("(FPS here)"){
                    {
                        this.setForeground(color);
                        PlateTectonicsTab.this.framesPerSecond.addObserver(new SimpleObserver(){

                            public void update() {
                                final double d = Math.round(PlateTectonicsTab.this.framesPerSecond.get() * 10.0) / 10L;
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        this.setText("FPS: " + d);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        };
        return new OrthoSwingNode(jPanel, this, this.canvasTransform, new Property<Vector2D>(new Vector2D(this.stageSize.getWidth() - jPanel.getPreferredSize().getWidth() - 200.0, 10.0)), this.mouseEventNotifier){
            {
                PlateTectonicsApplication.showFPSMeter.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible(PlateTectonicsApplication.showFPSMeter.get());
                    }
                });
                this.updateOnEvent(PlateTectonicsTab.this.beforeFrameRender);
            }
        };
    }

    public Vector2F getMouseViewPositionOnZPlane() {
        Ray3F ray3F = this.getCameraRay(Mouse.getEventX(), Mouse.getEventY());
        Vector3F vector3F = PlaneF.XY.intersectWithRay(ray3F);
        return new Vector2F(vector3F.x, vector3F.y);
    }

    public Vector2F getViewPositionOnZPlane(float f, float f2) {
        Ray3F ray3F = this.getCameraRay((int)((float)((Dimension)this.canvasSize.get()).width * f), (int)((float)((Dimension)this.canvasSize.get()).height * f2));
        Vector3F vector3F = PlaneF.XY.intersectWithRay(ray3F);
        return new Vector2F(vector3F.x, vector3F.y);
    }

    public Vector2F getBottomCenterPositionOnPlane(PlaneF planeF) {
        Ray3F ray3F = this.getCameraRay(((Dimension)this.canvasSize.get()).width / 2, 0);
        Vector3F vector3F = planeF.intersectWithRay(ray3F);
        return new Vector2F(vector3F.x, vector3F.y);
    }

    public void addGuiNode(OrthoSwingNode orthoSwingNode) {
        this.guiLayer.addChild(orthoSwingNode);
        this.guiNodes.add(orthoSwingNode);
    }

    public OrthoSwingNode getGuiUnder(int n, int n2) {
        for (OrthoSwingNode orthoSwingNode : this.guiNodes) {
            if (!this.isGuiUnder(orthoSwingNode, n, n2)) continue;
            return orthoSwingNode;
        }
        return null;
    }

    public boolean isGuiUnder(OrthoSwingNode orthoSwingNode, int n, int n2) {
        Vector2F vector2F = new Vector2F(n, n2);
        if (orthoSwingNode.isReady()) {
            Vector2F vector2F2 = orthoSwingNode.screentoComponentCoordinates(vector2F);
            if (orthoSwingNode.getComponent().contains((int)vector2F2.x, (int)vector2F2.y)) {
                return true;
            }
        }
        return false;
    }

    public ArrayList<GLNode> getToolNodes() {
        return new ArrayList<GLNode>(this.toolLayer.getChildren()){
            {
                Collections.reverse(this);
            }
        };
    }

    public ThreadedPlanarPiccoloNode getToolUnder(int n, int n2) {
        for (GLNode gLNode : this.getToolNodes()) {
            Ray3F ray3F;
            Ray3F ray3F2;
            ThreadedPlanarPiccoloNode threadedPlanarPiccoloNode = (ThreadedPlanarPiccoloNode)gLNode;
            if (!threadedPlanarPiccoloNode.doesLocalRayHit(ray3F2 = threadedPlanarPiccoloNode.transform.inverseRay(ray3F = this.getCameraRay(n, n2)))) continue;
            return threadedPlanarPiccoloNode;
        }
        return null;
    }

    public void updateCursor() {
        final LWJGLCanvas lWJGLCanvas = this.getCanvas();
        final ThreadedPlanarPiccoloNode threadedPlanarPiccoloNode = this.getToolUnder(Mouse.getEventX(), Mouse.getEventY());
        final OrthoSwingNode orthoSwingNode = this.getGuiUnder(Mouse.getEventX(), Mouse.getEventY());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (threadedPlanarPiccoloNode != null) {
                    lWJGLCanvas.setCursor(threadedPlanarPiccoloNode.getCursor());
                } else {
                    Component component;
                    Component component2 = component = orthoSwingNode == null ? null : orthoSwingNode.getComponentAt(Mouse.getX(), Mouse.getY());
                    if (component != null) {
                        lWJGLCanvas.setCursor(component.getCursor());
                    } else {
                        PlateTectonicsTab.this.uncaughtCursor();
                    }
                }
            }
        });
    }

    protected void uncaughtCursor() {
        this.getCanvas().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void pickedCrustPiece(OrthoPiccoloNode orthoPiccoloNode) {
        CrustPieceNode crustPieceNode = (CrustPieceNode)orthoPiccoloNode.getNode();
        SimSharingManager.sendUserMessage(PlateTectonicsSimSharing.UserComponents.crustPiece, UserComponentTypes.sprite, UserActions.startDrag, new ParameterSet(new Parameter((IParameterKey)PlateTectonicsSimSharing.ParameterKeys.plateType, crustPieceNode.type.toString())));
    }

    public void movedCrustPiece(OrthoPiccoloNode orthoPiccoloNode) {
    }

    public void droppedCrustPiece(OrthoPiccoloNode orthoPiccoloNode) {
    }

    public void resetAll() {
        this.zoomRatio.reset();
        this.debugCameraTransform.set(Matrix4F.IDENTITY);
        this.model.resetAll();
        this.colorMode.reset();
        for (GLNode gLNode : this.getToolNodes()) {
            DraggableTool2D draggableTool2D = (DraggableTool2D)((Object)gLNode);
            if (draggableTool2D.getInsideToolboxProperty(this.toolboxState).get().booleanValue()) continue;
            draggableTool2D.recycle();
            draggableTool2D.getInsideToolboxProperty(this.toolboxState).set(true);
        }
    }

    public TectonicsClock getClock() {
        return this.clock;
    }

    protected void uncaughtMouseButton() {
    }

    public Property<Vector3F> getLabelPosition(final Property<Vector3F> property, final Property<Vector3F> property2, final Property<Float> property3) {
        return new Property<Vector3F>(new Vector3F()){
            {
                super(vector3F);
                final SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        PlaneF planeF = new PlaneF(new Vector3F(0.0f, 0.0f, 1.0f), ((Vector3F)property.get()).getZ());
                        Vector2F vector2F = PlateTectonicsTab.this.getBottomCenterPositionOnPlane(planeF);
                        if (((Vector3F)property2.get()).y < vector2F.y) {
                            float f = (vector2F.y + ((Vector3F)property.get()).y) / 2.0f;
                            float f2 = (f - ((Vector3F)property.get()).y) / (((Vector3F)property2.get()).y - ((Vector3F)property.get()).y);
                            this.set(((Vector3F)property.get()).times(1.0f - f2).plus(((Vector3F)property2.get()).times(f2)));
                        } else {
                            this.set(((Vector3F)property.get()).plus((AbstractVector3F)property2.get()).times(0.5f));
                        }
                    }
                };
                property3.addObserver(simpleObserver);
                PlateTectonicsTab.this.beforeFrameRender.addUpdateListener(new UpdateListener(){

                    public void update() {
                        simpleObserver.update();
                    }
                }, false);
            }
        };
    }

    public abstract boolean isWaterVisible();

    public boolean isToolInBounds(DraggableTool2D draggableTool2D) {
        Vector2F vector2F = this.getViewPositionOnZPlane(0.5f, 0.0f);
        Vector2F vector2F2 = this.getViewPositionOnZPlane(0.5f, 1.0f);
        Vector2F vector2F3 = this.getViewPositionOnZPlane(0.0f, 0.5f);
        Vector2F vector2F4 = this.getViewPositionOnZPlane(1.0f, 0.5f);
        Vector3F vector3F = draggableTool2D.getSensorViewPosition();
        return !(vector3F.getY() <= vector2F.getY() || vector3F.getX() >= vector2F4.getX() || vector3F.getX() <= vector2F3.getX() || vector3F.getY() >= vector2F2.getY());
    }
}

