/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.tabs;

import edu.colorado.phet.common.phetcommon.math.Bounds3F;
import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.Ray3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import edu.colorado.phet.lwjglphet.LWJGLTab;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.nodes.GuiNode;
import edu.colorado.phet.lwjglphet.nodes.OrthoPiccoloNode;
import edu.colorado.phet.platetectonics.PlateTectonicsApplication;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import edu.colorado.phet.platetectonics.control.CrustChooserPanel;
import edu.colorado.phet.platetectonics.control.CrustPieceNode;
import edu.colorado.phet.platetectonics.control.MotionTypeChooserPanel;
import edu.colorado.phet.platetectonics.control.PlayModePanel;
import edu.colorado.phet.platetectonics.control.ResetPanel;
import edu.colorado.phet.platetectonics.control.TectonicsTimeControl;
import edu.colorado.phet.platetectonics.control.ViewOptionsPanel;
import edu.colorado.phet.platetectonics.model.Handle;
import edu.colorado.phet.platetectonics.model.PlateMotionModel;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.PlateType;
import edu.colorado.phet.platetectonics.model.TectonicsClock;
import edu.colorado.phet.platetectonics.model.labels.RangeLabel;
import edu.colorado.phet.platetectonics.model.labels.TextLabel;
import edu.colorado.phet.platetectonics.tabs.PlateTectonicsTab;
import edu.colorado.phet.platetectonics.util.MortalUpdateListener;
import edu.colorado.phet.platetectonics.util.Side;
import edu.colorado.phet.platetectonics.view.BoxHighlightNode;
import edu.colorado.phet.platetectonics.view.HandleNode;
import edu.colorado.phet.platetectonics.view.PlateMotionView;
import edu.colorado.phet.platetectonics.view.labels.RangeLabelNode;
import edu.colorado.phet.platetectonics.view.labels.TextLabelNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.input.Mouse;

public class PlateMotionTab
extends PlateTectonicsTab {
    public final Property<Boolean> isAutoMode = new Property<Boolean>(false);
    private CrustChooserPanel crustChooserPanel;
    private OrthoPiccoloNode crustChooserNode;
    private GuiNode crustPieceLayer;
    public final Property<Boolean> showLabels = new Property<Boolean>(false);
    public final Property<Boolean> showWater = new Property<Boolean>(false);
    private final List<OrthoPiccoloNode> placedPieces = new ArrayList<OrthoPiccoloNode>();
    private OrthoPiccoloNode motionTypeChooserPanel = null;
    private boolean draggingHandle = false;
    private HandleNode activeHandle = null;
    private Vector2F draggingPlateStartMousePosition = null;
    private boolean pressingArrow = false;
    public final Property<Vector2F> motionVectorRight = new Property<Vector2F>(new Vector2F());
    private HandleNode leftHandle;
    private HandleNode rightHandle;
    private TectonicsTimeControl tectonicsTimeControl;
    public final Map<RangeLabel, RangeLabelNode> rangeLabelMap = new HashMap<RangeLabel, RangeLabelNode>();
    public final Map<TextLabel, TextLabelNode> textLabelMap = new HashMap<TextLabel, TextLabelNode>();

    public PlateMotionTab(LWJGLCanvas lWJGLCanvas) {
        super(lWJGLCanvas, PlateTectonicsResources.Strings.PLATE_MOTION_TAB, 0.5f);
    }

    public void initialize() {
        super.initialize();
        this.crustPieceLayer = new GuiNode(this);
        this.rootNode.addChild(this.crustPieceLayer);
        Bounds3F bounds3F = Bounds3F.fromMinMax(-700000.0f, 700000.0f, -300000.0f, 15000.0f, -1000000.0f, 0.0f);
        this.setModel(new PlateMotionModel(this.getClock(), bounds3F));
        this.sceneLayer.addChild(new PlateMotionView(this.getPlateMotionModel(), this, this.showWater));
        this.leftHandle = new HandleNode(new Handle(this.motionVectorRight, false, this), new Property<Vector3F>(new Vector3F(-120.0f, 0.0f, -62.0f)), this);
        this.sceneLayer.addChild(this.leftHandle);
        this.rightHandle = new HandleNode(new Handle(this.motionVectorRight, true, this), new Property<Vector3F>(new Vector3F(120.0f, 0.0f, -62.0f)), this);
        this.sceneLayer.addChild(this.rightHandle);
        final GLNode gLNode = new GLNode(){
            {
                PlateMotionTab.this.showLabels.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible(PlateMotionTab.this.showLabels.get());
                    }
                });
            }
        };
        this.sceneLayer.addChild(gLNode);
        this.getPlateMotionModel().rangeLabels.addElementAddedObserver(new VoidFunction1<RangeLabel>(){

            @Override
            public void apply(final RangeLabel rangeLabel) {
                Property<Vector3F> property = new Property<Vector3F>(new Vector3F()){
                    {
                        super(vector3F);
                        PlateMotionTab.this.beforeFrameRender.addUpdateListener(new MortalUpdateListener(PlateMotionTab.this.beforeFrameRender, rangeLabel.disposed){

                            public void update() {
                                this.set(PlateMotionTab.this.convertRadial(rangeLabel.top.get()));
                            }
                        }, true);
                    }
                };
                Property<Vector3F> property2 = new Property<Vector3F>(new Vector3F()){
                    {
                        super(vector3F);
                        PlateMotionTab.this.beforeFrameRender.addUpdateListener(new MortalUpdateListener(PlateMotionTab.this.beforeFrameRender, rangeLabel.disposed){

                            public void update() {
                                this.set(PlateMotionTab.this.convertRadial(rangeLabel.bottom.get()));
                            }
                        }, true);
                    }
                };
                RangeLabelNode rangeLabelNode = new RangeLabelNode(rangeLabel, property, property2, rangeLabel.label, new Property<Float>(Float.valueOf(1.0f)), PlateMotionTab.this.colorMode, true);
                gLNode.addChild(rangeLabelNode);
                PlateMotionTab.this.rangeLabelMap.put(rangeLabel, rangeLabelNode);
            }
        });
        this.getPlateMotionModel().rangeLabels.addElementRemovedObserver(new VoidFunction1<RangeLabel>(){

            @Override
            public void apply(RangeLabel rangeLabel) {
                gLNode.removeChild(PlateMotionTab.this.rangeLabelMap.get(rangeLabel));
                PlateMotionTab.this.rangeLabelMap.remove(rangeLabel);
            }
        });
        this.getPlateMotionModel().textLabels.addElementAddedObserver(new VoidFunction1<TextLabel>(){

            @Override
            public void apply(TextLabel textLabel) {
                TextLabelNode textLabelNode = new TextLabelNode(textLabel, PlateMotionTab.this.getModelViewTransform(), PlateMotionTab.this.colorMode, new Property<Float>(Float.valueOf(1.0f)));
                gLNode.addChild(textLabelNode);
                PlateMotionTab.this.textLabelMap.put(textLabel, textLabelNode);
            }
        });
        this.getPlateMotionModel().textLabels.addElementRemovedObserver(new VoidFunction1<TextLabel>(){

            @Override
            public void apply(TextLabel textLabel) {
                gLNode.removeChild(PlateMotionTab.this.textLabelMap.get(textLabel));
                PlateMotionTab.this.textLabelMap.remove(textLabel);
            }
        });
        final Color color = new Color(1.0f, 1.0f, 0.5f, 0.3f);
        final Color color2 = new Color(0.5f, 0.5f, 0.5f, 0.3f);
        final Property<Color> property = new Property<Color>(color2);
        this.sceneLayer.addChild(new BoxHighlightNode(this.getPlateMotionModel().getLeftDropAreaBounds(), this.getModelViewTransform(), property){
            {
                PlateMotionTab.this.getPlateMotionModel().leftPlateType.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible(PlateMotionTab.this.getPlateMotionModel().leftPlateType.get() == null);
                    }
                });
            }
        });
        final Property<Color> property2 = new Property<Color>(color2);
        this.sceneLayer.addChild(new BoxHighlightNode(this.getPlateMotionModel().getRightDropAreaBounds(), this.getModelViewTransform(), property2){
            {
                PlateMotionTab.this.getPlateMotionModel().rightPlateType.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible(PlateMotionTab.this.getPlateMotionModel().rightPlateType.get() == null);
                    }
                });
            }
        });
        this.mouseEventNotifier.addUpdateListener(new UpdateListener(){

            public void update() {
                if (PlateMotionTab.this.draggedCrustPiece == null || PlateMotionTab.this.isMouseOverCrustChooser()) {
                    property.set(color2);
                    property2.set(color2);
                } else {
                    boolean bl = PlateMotionTab.this.isMouseOverLeftSide();
                    property.set(bl ? color : color2);
                    property2.set(!bl ? color : color2);
                }
            }
        }, false);
        final OrthoPiccoloNode orthoPiccoloNode = new OrthoPiccoloNode(new ControlPanelNode((PNode)new PlayModePanel(this.isAutoMode)), this, this.getCanvasTransform(), new Property<Vector2D>(new Vector2D(10.0, 10.0)), this.mouseEventNotifier){
            {
                this.updateOnEvent(PlateMotionTab.this.beforeFrameRender);
            }
        };
        this.addGuiNode(orthoPiccoloNode);
        this.crustChooserPanel = new CrustChooserPanel();
        this.crustChooserNode = new OrthoPiccoloNode(new ControlPanelNode((PNode)this.crustChooserPanel), this, this.getCanvasTransform(), new Property<Vector2D>(new Vector2D()), this.mouseEventNotifier){
            {
                PlateMotionTab.this.canvasSize.addObserver(new SimpleObserver(){

                    public void update() {
                        position.set(new Vector2D(PlateMotionTab.this.getStageSize().width - this.getComponentWidth() - 10, PlateMotionTab.this.getStageSize().height - this.getComponentHeight() - 10));
                    }
                });
                this.updateOnEvent(PlateMotionTab.this.beforeFrameRender);
                PlateMotionTab.this.getPlateMotionModel().hasBothPlates.addObserver(new ChangeObserver<Boolean>(){

                    @Override
                    public void update(Boolean bl, Boolean bl2) {
                        this.setVisible(bl == false);
                    }
                });
            }
        };
        this.addGuiNode(this.crustChooserNode);
        this.addCrustPieceGLNode(new CrustPieceGLNode(new CrustPieceNode(PlateType.CONTINENTAL, 100.0f, 0.8f), this.getContinentalOffset()));
        this.addCrustPieceGLNode(new CrustPieceGLNode(new CrustPieceNode(PlateType.CONTINENTAL, 100.0f, 0.8f), this.getContinentalOffset()));
        this.addCrustPieceGLNode(new CrustPieceGLNode(new CrustPieceNode(PlateType.YOUNG_OCEANIC, 35.0f, 0.5f), this.getYoungOceanicOffset()));
        this.addCrustPieceGLNode(new CrustPieceGLNode(new CrustPieceNode(PlateType.YOUNG_OCEANIC, 35.0f, 0.5f), this.getYoungOceanicOffset()));
        this.addCrustPieceGLNode(new CrustPieceGLNode(new CrustPieceNode(PlateType.OLD_OCEANIC, 35.0f, 0.4f), this.getOldOceanicOffset()));
        this.addCrustPieceGLNode(new CrustPieceGLNode(new CrustPieceNode(PlateType.OLD_OCEANIC, 35.0f, 0.4f), this.getOldOceanicOffset()));
        final OrthoPiccoloNode orthoPiccoloNode2 = new OrthoPiccoloNode(new ControlPanelNode((PNode)new ViewOptionsPanel(this.showLabels, true, this.showWater, this.getPlateMotionModel().hasBothPlates, this.colorMode)), this, this.getCanvasTransform(), new Property<Vector2D>(new Vector2D()), this.mouseEventNotifier){
            {
                this.updateOnEvent(PlateMotionTab.this.beforeFrameRender);
            }
        };
        this.addGuiNode(orthoPiccoloNode2);
        final OrthoPiccoloNode orthoPiccoloNode3 = new OrthoPiccoloNode(new ResetPanel(this, new Runnable(){

            public void run() {
                PlateMotionTab.this.resetAll();
            }
        }), this, this.getCanvasTransform(), new Property<Vector2D>(new Vector2D()), this.mouseEventNotifier){
            {
                this.updateOnEvent(PlateMotionTab.this.beforeFrameRender);
            }
        };
        this.addGuiNode(orthoPiccoloNode3);
        this.canvasSize.addObserver(new SimpleObserver(){

            public void update() {
                double d = ((Vector2D)PlateMotionTab.this.toolboxNode.position.get()).getX() + (double)PlateMotionTab.this.toolboxNode.getComponentWidth();
                double d2 = ((Vector2D)((PlateMotionTab)PlateMotionTab.this).crustChooserNode.position.get()).getX();
                double d3 = orthoPiccoloNode2.getComponentWidth();
                double d4 = orthoPiccoloNode3.getComponentWidth();
                double d5 = d2 - d - d3 - d4;
                double d6 = d5 / 3.0;
                orthoPiccoloNode2.position.set(new Vector2D((int)(d + d6), PlateMotionTab.this.getStageSize().height - orthoPiccoloNode2.getComponentHeight() - 10));
                orthoPiccoloNode3.position.set(new Vector2D((int)(d + d6 + d3 + d6), PlateMotionTab.this.getStageSize().height - orthoPiccoloNode3.getComponentHeight() - 25));
            }
        });
        this.tectonicsTimeControl = new TectonicsTimeControl(this.getClock(), this.isAutoMode);
        final double d = new ControlPanelNode((PNode)new TectonicsTimeControl(new TectonicsClock(1.0), new Property<Boolean>(true))).getFullBounds().getWidth();
        OrthoPiccoloNode orthoPiccoloNode4 = new OrthoPiccoloNode(new ZeroOffsetNode((PNode)new ControlPanelNode((PNode)this.tectonicsTimeControl)), this, this.getCanvasTransform(), new Property<Vector2D>(new Vector2D()), this.mouseEventNotifier){
            {
                super(pNode, lWJGLTab, canvasTransform, (Property<Vector2D>)property, voidNotifier);
                final Runnable runnable = new Runnable(){

                    public void run() {
                        double d = PlateTectonicsApplication.moveTimeControl.get() != false ? (double)this.getComponentWidth() : d;
                        position.set(new Vector2D((double)PlateMotionTab.this.getStageSize().width - d - 10.0, 10.0));
                    }
                };
                this.onResize.addUpdateListener(new UpdateListener(){

                    public void update() {
                        runnable.run();
                    }
                }, true);
                PlateTectonicsApplication.moveTimeControl.addObserver(new SimpleObserver(){

                    public void update() {
                        runnable.run();
                    }
                }, false);
                this.position.set(new Vector2D((double)PlateMotionTab.this.getStageSize().width - d - 10.0, 10.0));
                this.updateOnEvent(PlateMotionTab.this.beforeFrameRender);
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        this.setVisible(PlateMotionTab.this.getPlateMotionModel().hasBothPlates.get());
                    }
                };
                PlateMotionTab.this.getPlateMotionModel().hasBothPlates.addObserver(simpleObserver);
            }
        };
        this.addGuiNode(orthoPiccoloNode4);
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                boolean bl;
                boolean bl2 = PlateMotionTab.this.getPlateMotionModel().leftPlateType.get() != null;
                boolean bl3 = PlateMotionTab.this.getPlateMotionModel().rightPlateType.get() != null;
                boolean bl4 = PlateMotionTab.this.isAutoMode.get();
                boolean bl5 = bl = bl2 && bl3 && bl4;
                if (bl && PlateMotionTab.this.motionTypeChooserPanel == null) {
                    PlateMotionTab.this.motionTypeChooserPanel = new OrthoPiccoloNode(new ControlPanelNode((PNode)new MotionTypeChooserPanel(PlateMotionTab.this.getPlateMotionModel())), PlateMotionTab.this, PlateMotionTab.this.getCanvasTransform(), new Property<Vector2D>(new Vector2D()), PlateMotionTab.this.mouseEventNotifier){
                        {
                            double d = ((Vector2D)orthoPiccoloNode.position.get()).getX() + (double)orthoPiccoloNode.getComponentWidth();
                            double d2 = (double)PlateMotionTab.this.getStageSize().width - d - 10.0;
                            this.position.set(new Vector2D((d + d2 - (double)this.getComponentWidth()) * 0.5, 10.0));
                            this.updateOnEvent(PlateMotionTab.this.beforeFrameRender);
                        }
                    };
                    PlateMotionTab.this.addGuiNode(PlateMotionTab.this.motionTypeChooserPanel);
                }
                if (!bl && PlateMotionTab.this.motionTypeChooserPanel != null) {
                    PlateMotionTab.this.guiNodes.remove(PlateMotionTab.this.motionTypeChooserPanel);
                    PlateMotionTab.this.guiLayer.removeChild(PlateMotionTab.this.motionTypeChooserPanel);
                    PlateMotionTab.this.motionTypeChooserPanel = null;
                }
            }
        };
        this.getPlateMotionModel().leftPlateType.addObserver(simpleObserver, false);
        this.getPlateMotionModel().rightPlateType.addObserver(simpleObserver, false);
        this.isAutoMode.addObserver(simpleObserver, false);
        this.timeChangeNotifier.addUpdateListener(new UpdateListener(){

            public void update() {
                if (PlateMotionTab.this.draggingHandle) {
                    Ray3F ray3F = PlateMotionTab.this.getCameraRay(Mouse.getX(), Mouse.getY());
                    PlateMotionTab.this.activeHandle.dragHandle(ray3F);
                }
                if ((PlateMotionTab.this.draggingHandle || PlateMotionTab.this.pressingArrow) && PlateMotionTab.this.getPlateMotionModel().motionType.get() != null) {
                    switch (PlateMotionTab.this.getPlateMotionModel().motionType.get()) {
                        case CONVERGENT: {
                            if (PlateMotionTab.this.motionVectorRight.get().x == 0.0f) break;
                            PlateMotionTab.this.manualHandleDragTimeChange(PlateMotionTab.this.getTimeElapsed() * Math.abs(PlateMotionTab.this.mapDragMagnitude(PlateMotionTab.this.motionVectorRight.get().x)));
                            break;
                        }
                        case DIVERGENT: {
                            if (PlateMotionTab.this.motionVectorRight.get().x == 0.0f) break;
                            PlateMotionTab.this.manualHandleDragTimeChange(PlateMotionTab.this.getTimeElapsed() * Math.abs(PlateMotionTab.this.mapDragMagnitude(PlateMotionTab.this.motionVectorRight.get().x)));
                            break;
                        }
                        case TRANSFORM: {
                            if (PlateMotionTab.this.motionVectorRight.get().y == 0.0f) break;
                            PlateMotionTab.this.manualHandleDragTimeChange(PlateMotionTab.this.getTimeElapsed() * Math.abs(PlateMotionTab.this.mapDragMagnitude(PlateMotionTab.this.motionVectorRight.get().y)));
                        }
                    }
                }
            }
        }, false);
        this.guiLayer.addChild(this.createFPSReadout(Color.BLACK));
        this.showWater.addObserver(new ChangeObserver<Boolean>(){

            @Override
            public void update(Boolean bl, Boolean bl2) {
                PlateMotionTab.this.getModel().modelChanged.updateListeners();
            }
        });
    }

    private void manualHandleDragTimeChange(float f) {
        if (!Float.isNaN(f)) {
            SimSharingManager.sendUserMessage(PlateTectonicsSimSharing.UserComponents.handle, UserComponentTypes.sprite, UserActions.drag, new ParameterSet(new Parameter[]{new Parameter((IParameterKey)PlateTectonicsSimSharing.ParameterKeys.timeChangeMillionsOfYears, f), new Parameter((IParameterKey)PlateTectonicsSimSharing.ParameterKeys.motionType, this.getPlateMotionModel().motionType.get().toString())}));
            this.getClock().stepByWallSecondsForced(f);
        }
    }

    private float mapDragMagnitude(float f) {
        return f * f * 2.5f;
    }

    private Vector2F getCrustOffset(Vector2F vector2F) {
        Vector2D vector2D = (Vector2D)this.crustChooserNode.position.get();
        return new Vector2F((float)vector2D.getX() + vector2F.x, (float)vector2D.getY() + vector2F.y);
    }

    private Vector2F getContinentalOffset() {
        return this.getCrustOffset(this.crustChooserPanel.getContinentalCenter());
    }

    private Vector2F getYoungOceanicOffset() {
        return this.getCrustOffset(this.crustChooserPanel.getYoungOceanicCenter());
    }

    private Vector2F getOldOceanicOffset() {
        return this.getCrustOffset(this.crustChooserPanel.getOldOceanicCenter());
    }

    public PlateMotionModel getPlateMotionModel() {
        return (PlateMotionModel)this.getModel();
    }

    public void droppedCrustPiece(OrthoPiccoloNode orthoPiccoloNode) {
        PlateMotionModel plateMotionModel = this.getPlateMotionModel();
        CrustPieceNode crustPieceNode = (CrustPieceNode)orthoPiccoloNode.getNode();
        ParameterSet parameterSet = new ParameterSet(new Parameter((IParameterKey)PlateTectonicsSimSharing.ParameterKeys.plateType, crustPieceNode.type.toString()));
        if (this.isMouseOverCrustChooser()) {
            orthoPiccoloNode.position.reset();
            SimSharingManager.sendUserMessage(PlateTectonicsSimSharing.UserComponents.crustPiece, UserComponentTypes.sprite, PlateTectonicsSimSharing.UserActions.putBackInCrustPicker, parameterSet);
        } else {
            Side side = this.isMouseOverLeftSide() ? Side.LEFT : Side.RIGHT;
            parameterSet = parameterSet.with(new Parameter((IParameterKey)PlateTectonicsSimSharing.ParameterKeys.side, side.toString()));
            if (!plateMotionModel.hasPlate(side)) {
                plateMotionModel.dropCrust(side, crustPieceNode.type);
                this.placedPieces.add(orthoPiccoloNode);
                this.removeCrustPieceGLNode((CrustPieceGLNode)orthoPiccoloNode);
                SimSharingManager.sendUserMessage(PlateTectonicsSimSharing.UserComponents.crustPiece, UserComponentTypes.sprite, PlateTectonicsSimSharing.UserActions.droppedCrustPiece, parameterSet);
            } else {
                orthoPiccoloNode.position.reset();
                SimSharingManager.sendUserMessage(PlateTectonicsSimSharing.UserComponents.crustPiece, UserComponentTypes.sprite, PlateTectonicsSimSharing.UserActions.attemptedToDropOnExistingCrust, parameterSet);
            }
        }
    }

    public void addCrustPieceGLNode(CrustPieceGLNode crustPieceGLNode) {
        this.crustPieceLayer.addChild(crustPieceGLNode);
        this.guiNodes.add(0, crustPieceGLNode);
        crustPieceGLNode.setVisible(true);
    }

    public void removeCrustPieceGLNode(CrustPieceGLNode crustPieceGLNode) {
        this.crustPieceLayer.removeChild(crustPieceGLNode);
        this.guiNodes.remove(crustPieceGLNode);
        crustPieceGLNode.setVisible(false);
    }

    public void resetAll() {
        super.resetAll();
        this.showLabels.reset();
        this.showWater.reset();
        this.isAutoMode.reset();
        this.getClock().pause();
        this.getClock().resetTimeLimit();
        this.getClock().resetSimulationTime();
        this.tectonicsTimeControl.resetAll();
        for (OrthoPiccoloNode orthoPiccoloNode : this.placedPieces) {
            this.addCrustPieceGLNode((CrustPieceGLNode)orthoPiccoloNode);
            orthoPiccoloNode.position.reset();
        }
    }

    public void newCrust() {
        this.getPlateMotionModel().newCrust();
        this.getClock().pause();
        this.getClock().resetSimulationTime();
        this.getPlateMotionModel().resetAll();
        for (OrthoPiccoloNode orthoPiccoloNode : this.placedPieces) {
            this.addCrustPieceGLNode((CrustPieceGLNode)orthoPiccoloNode);
            orthoPiccoloNode.position.reset();
        }
    }

    private boolean isMouseOverLeftSide() {
        return this.getMouseViewPositionOnZPlane().x < 0.0f;
    }

    private boolean isMouseOverCrustChooser() {
        return this.isGuiUnder(this.crustChooserNode, Mouse.getEventX(), Mouse.getEventY());
    }

    public Matrix4F getSceneModelViewMatrix() {
        Matrix4F matrix4F = super.getSceneModelViewMatrix();
        return Matrix4F.rowMajor(0.99994993f, -3.9991664E-4f, -0.009994832f, 0.0f, 1.9998333E-4f, 0.9998f, -0.019996665f, 0.0f, 0.010000832f, 0.01999366f, 0.99975f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).times(Matrix4F.rowMajor(0.99955106f, -5.982099E-4f, 0.029960573f, 0.0f, -2.248562E-6f, 0.9997994f, 0.02003758f, 0.0f, -0.029966524f, -0.020028654f, 0.99935055f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).times(Matrix4F.rowMajor(1.0f, 0.0f, 0.0f, 12.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 78.0f, 0.0f, 0.0f, 0.0f, 1.0f).times(Matrix4F.rowMajor(0.9939557f, 7.9941313E-4f, -0.109775305f, -58.643387f, -0.0018950196f, 0.9999494f, -0.0098764775f, 0.11180614f, 0.109761804f, 0.010024817f, 0.9939069f, -6.4759464f, 0.0f, 0.0f, 0.0f, 1.0f).times(matrix4F))));
    }

    public boolean allowClockTickOnFrame() {
        return this.isAutoMode.get();
    }

    protected void uncaughtCursor() {
        Ray3F ray3F = this.getCameraRay(Mouse.getEventX(), Mouse.getEventY());
        boolean bl = this.isOverRightHandle(ray3F) || this.isOverRightHandleArrow(ray3F);
        boolean bl2 = this.isOverLeftHandle(ray3F) || this.isOverLeftHandleArrow(ray3F);
        Boolean bl3 = this.getPlateMotionModel().hasBothPlates.get() != false && (bl || bl2) || this.draggingHandle;
        this.getCanvas().setCursor(Cursor.getPredefinedCursor(bl3 != false ? 12 : 0));
    }

    private boolean isOverLeftHandle(Ray3F ray3F) {
        return this.leftHandle.isVisible() && this.leftHandle.rayIntersectsHandle(ray3F);
    }

    private boolean isOverRightHandle(Ray3F ray3F) {
        return this.rightHandle.isVisible() && this.rightHandle.rayIntersectsHandle(ray3F);
    }

    private boolean isOverLeftHandleArrow(Ray3F ray3F) {
        return this.leftHandle.isVisible() && this.leftHandle.rayIntersectsArrow(ray3F).isSome();
    }

    private boolean isOverRightHandleArrow(Ray3F ray3F) {
        return this.rightHandle.isVisible() && this.rightHandle.rayIntersectsArrow(ray3F).isSome();
    }

    protected void uncaughtMouseButton() {
        if (!this.isAutoMode.get().booleanValue()) {
            Ray3F ray3F = this.getCameraRay(Mouse.getEventX(), Mouse.getEventY());
            boolean bl = this.isOverLeftHandle(ray3F);
            boolean bl2 = this.isOverRightHandle(ray3F);
            boolean bl3 = this.isOverLeftHandleArrow(ray3F);
            boolean bl4 = this.isOverRightHandleArrow(ray3F);
            if (Mouse.getEventButtonState() && (bl || bl2)) {
                this.draggingHandle = true;
                this.draggingPlateStartMousePosition = this.getMouseViewPositionOnZPlane();
                if (bl) {
                    this.leftHandle.startHandleDrag(ray3F);
                    this.activeHandle = this.leftHandle;
                } else {
                    this.rightHandle.startHandleDrag(ray3F);
                    this.activeHandle = this.rightHandle;
                }
            } else if (Mouse.getEventButtonState() && (bl3 || bl4)) {
                this.pressingArrow = true;
                if (bl3) {
                    this.leftHandle.startArrowPress(ray3F);
                    this.activeHandle = this.leftHandle;
                } else {
                    this.rightHandle.startArrowPress(ray3F);
                    this.activeHandle = this.rightHandle;
                }
            } else {
                if (this.activeHandle != null) {
                    if (this.draggingHandle) {
                        this.activeHandle.endHandleDrag();
                    } else if (this.pressingArrow) {
                        this.activeHandle.endArrowPress();
                    }
                    this.activeHandle = null;
                }
                this.draggingHandle = false;
                this.pressingArrow = false;
                this.motionVectorRight.reset();
            }
        }
    }

    private Vector3F convertRadial(Vector3F vector3F) {
        return this.getModelViewTransform().transformPosition(PlateTectonicsModel.convertToRadial(vector3F));
    }

    public IUserComponent getUserComponent() {
        return PlateTectonicsSimSharing.UserComponents.plateMotionTab;
    }

    public boolean isWaterVisible() {
        return this.showWater.get();
    }

    private class CrustPieceGLNode
    extends OrthoPiccoloNode {
        private CrustPieceGLNode(CrustPieceNode crustPieceNode, Vector2F vector2F) {
            super(crustPieceNode, (LWJGLTab)PlateMotionTab.this, PlateMotionTab.this.getCanvasTransform(), new Property<Vector2D>(new Vector2D((double)vector2F.x - crustPieceNode.getFullBounds().getWidth() / 2.0, (double)vector2F.y - crustPieceNode.getFullBounds().getHeight() / 2.0)), PlateMotionTab.this.mouseEventNotifier);
            PlateMotionTab.this.getPlateMotionModel().hasBothPlates.addObserver(new ChangeObserver<Boolean>(){

                @Override
                public void update(Boolean bl, Boolean bl2) {
                    CrustPieceGLNode.this.setVisible(bl == false);
                    CrustPieceGLNode.this.setMouseEnabled(bl == false);
                }
            });
        }
    }
}

