/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model.regions;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.ValueNotifier;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.TextureStrategy;
import edu.colorado.phet.platetectonics.model.regions.Boundary;
import edu.colorado.phet.platetectonics.model.regions.CrossSectionStrip;
import edu.colorado.phet.platetectonics.util.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Region {
    public final ValueNotifier<Region> disposed = new ValueNotifier<Region>(this);
    private List<Boundary> boundaries = new ArrayList<Boundary>();
    private List<CrossSectionStrip> strips = new ArrayList<CrossSectionStrip>();

    public Region(int n, int n2, Function2<Integer, Integer, Sample> function2) {
        Object object;
        int n3;
        int n4 = n + 1;
        for (n3 = 0; n3 < n4; ++n3) {
            object = new Boundary();
            this.boundaries.add((Boundary)object);
            for (int i = 0; i < n2; ++i) {
                ((Boundary)object).samples.add(function2.apply(n3, i));
            }
        }
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            object = new CrossSectionStrip(this.boundaries.get((int)n3).samples, this.boundaries.get((int)(n3 + 1)).samples);
            this.strips.add((CrossSectionStrip)object);
        }
    }

    public void addColumn(Side side, List<Sample> list) {
        int n;
        assert (list.size() == this.boundaries.size());
        for (n = 0; n < list.size(); ++n) {
            this.boundaries.get(n).addSample(side, list.get(n));
        }
        for (n = 0; n < this.strips.size(); ++n) {
            this.strips.get(n).addPatch(side, list.get(n), list.get(n + 1));
        }
    }

    public void removeColumn(Side side) {
        for (Boundary object : this.boundaries) {
            object.removeSample(side);
        }
        for (CrossSectionStrip crossSectionStrip : this.strips) {
            crossSectionStrip.removePatch(side);
        }
    }

    public float getTopElevation(int n) {
        return this.getTopBoundary().samples.get((int)n).getPosition().y;
    }

    public float getBottomElevation(int n) {
        return this.getBottomBoundary().samples.get((int)n).getPosition().y;
    }

    public void layoutColumn(int n, float f, float f2, TextureStrategy textureStrategy, boolean bl) {
        for (int i = 0; i < this.boundaries.size(); ++i) {
            Sample sample = this.boundaries.get((int)i).samples.get(n);
            Vector3F vector3F = sample.getPosition();
            float f3 = (float)i / (float)(this.boundaries.size() - 1);
            float f4 = vector3F.y;
            float f5 = (1.0f - f3) * f + f3 * f2;
            sample.setPosition(new Vector3F(vector3F.x, f5, vector3F.z));
            if (!bl) continue;
            sample.setTextureCoordinates(sample.getTextureCoordinates().plus(textureStrategy.mapFrontDelta(new Vector2F(0.0f, f5 - f4))));
        }
    }

    public void moveToFront() {
        for (CrossSectionStrip crossSectionStrip : this.strips) {
            crossSectionStrip.moveToFrontNotifier.updateListeners();
        }
    }

    public Boundary getTopBoundary() {
        return this.boundaries.get(0);
    }

    public Boundary getBottomBoundary() {
        return this.boundaries.get(this.boundaries.size() - 1);
    }

    public List<Boundary> getBoundaries() {
        return this.boundaries;
    }

    public List<CrossSectionStrip> getStrips() {
        return this.strips;
    }

    public List<Sample> getSamples() {
        return FunctionalUtils.flatten(FunctionalUtils.map(this.boundaries, new Function1<Boundary, Collection<? extends Sample>>(){

            @Override
            public Collection<? extends Sample> apply(Boundary boundary) {
                return boundary.samples;
            }
        }));
    }

    public void setAllAlphas(float f) {
        for (CrossSectionStrip crossSectionStrip : this.strips) {
            crossSectionStrip.alpha.set(Float.valueOf(f));
        }
    }
}

