/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model.regions;

import edu.colorado.phet.common.phetcommon.model.event.ValueNotifier;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.util.Side;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossSectionStrip {
    public final List<Sample> topPoints = new LinkedList<Sample>();
    public final List<Sample> bottomPoints = new LinkedList<Sample>();
    public final ValueNotifier<CrossSectionStrip> changed = new ValueNotifier<CrossSectionStrip>(this);
    public final ValueNotifier<CrossSectionStrip> moveToFrontNotifier = new ValueNotifier<CrossSectionStrip>(this);
    public final ValueNotifier<CrossSectionStrip> disposed = new ValueNotifier<CrossSectionStrip>(this);
    public final Property<Float> alpha = new Property<Float>(Float.valueOf(1.0f));

    public CrossSectionStrip() {
        this.alpha.addObserver(new SimpleObserver(){

            public void update() {
                CrossSectionStrip.this.changed.updateListeners();
            }
        });
    }

    public CrossSectionStrip(List<Sample> list, List<Sample> list2) {
        ListIterator<Sample> listIterator = list.listIterator();
        ListIterator<Sample> listIterator2 = list2.listIterator();
        while (listIterator.hasNext()) {
            this.addPatch(Side.RIGHT, listIterator.next(), listIterator2.next());
        }
    }

    public int getLength() {
        return this.topPoints.size();
    }

    public int getNumberOfVertices() {
        return this.topPoints.size() * 2;
    }

    public void addPatch(Side side, Sample sample, Sample sample2) {
        side.addToList(this.topPoints, sample);
        side.addToList(this.bottomPoints, sample2);
    }

    public void removePatch(Side side) {
        side.removeFromList(this.topPoints);
        side.removeFromList(this.bottomPoints);
    }

    public void update() {
        this.changed.updateListeners();
    }
}

