/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model.behaviors;

import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.platetectonics.model.PlateMotionModel;
import edu.colorado.phet.platetectonics.model.PlateMotionPlate;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.behaviors.PlateBehavior;

public class TransformBehavior
extends PlateBehavior {
    private final boolean towardsFront;
    private float timeElapsed = 0.0f;

    public TransformBehavior(PlateMotionPlate plateMotionPlate, PlateMotionPlate plateMotionPlate2, boolean bl) {
        super(plateMotionPlate, plateMotionPlate2);
        this.towardsFront = bl;
        PlateMotionModel plateMotionModel = plateMotionPlate.getModel();
        if (plateMotionModel.boundaryLabels.contains(plateMotionModel.joiningBoundaryLabel)) {
            plateMotionModel.boundaryLabels.remove(plateMotionModel.joiningBoundaryLabel);
        }
    }

    public void stepInTime(float f) {
        float f2 = this.timeElapsed;
        this.timeElapsed += f;
        float f3 = this.timeElapsed;
        this.getPlate().shiftZ(15000.0f * (this.towardsFront ? f : -f));
        float f4 = (float)(Math.exp(-f2 * 0.3f) - Math.exp(-f3 * 0.3f));
        float f5 = -f4 * 5000.0f;
        this.shiftIndexElevation(0, f5);
        this.shiftIndexElevation(1, f5 / 4.0f);
        this.shiftIndexElevation(2, -f5 / 4.0f);
        this.getPlate().getTerrain().elevationChanged.updateListeners();
    }

    public void shiftIndexElevation(int n, float f) {
        this.getTerrain().shiftColumnElevation(this.getOppositeSide().getFromIndex(this.getTerrain().getNumColumns(), n), f);
        Sample sample = this.getOppositeSide().getFromEnd(this.getCrust().getTopBoundary().samples, n);
        sample.setPosition(sample.getPosition().plus(Vector3F.Y_UNIT.times(f)));
    }
}

