/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model.behaviors;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.platetectonics.model.PlateMotionPlate;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.Terrain;
import edu.colorado.phet.platetectonics.model.labels.RangeLabel;
import edu.colorado.phet.platetectonics.model.regions.Boundary;
import edu.colorado.phet.platetectonics.model.regions.MagmaRegion;
import edu.colorado.phet.platetectonics.model.regions.Region;
import edu.colorado.phet.platetectonics.util.Side;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlateBehavior {
    public final PlateMotionPlate plate;
    public final PlateMotionPlate otherPlate;
    protected final List<MagmaRegion> magmaBlobs = new ArrayList<MagmaRegion>();
    protected Vector2F magmaTarget;
    protected MagmaRegion magmaChamber;
    protected float magmaSpeed;
    public final List<RangeLabel> rangeLabels;

    public PlateBehavior(PlateMotionPlate plateMotionPlate, PlateMotionPlate plateMotionPlate2) {
        this.plate = plateMotionPlate;
        this.otherPlate = plateMotionPlate2;
        this.rangeLabels = plateMotionPlate.getModel().rangeLabels;
    }

    public void afterConstructionInit() {
    }

    public abstract void stepInTime(float var1);

    public PlateMotionPlate getOtherPlate() {
        return this.otherPlate;
    }

    public PlateMotionPlate getPlate() {
        return this.plate;
    }

    public Side getSide() {
        return this.getPlate().getSide();
    }

    public Side getOppositeSide() {
        return this.getSide().opposite();
    }

    public int getNumCrustXSamples() {
        return this.getCrust().getTopBoundary().samples.size();
    }

    public int getNumTerrainXSamples() {
        return this.getTerrain().getNumColumns();
    }

    public Terrain getTerrain() {
        return this.plate.getTerrain();
    }

    public Region getCrust() {
        return this.plate.getCrust();
    }

    public Region getLithosphere() {
        return this.plate.getLithosphere();
    }

    public Region[] getLithosphereRegions() {
        return new Region[]{this.getCrust(), this.getLithosphere()};
    }

    public Boundary getTopCrustBoundary() {
        return this.getCrust().getTopBoundary();
    }

    protected void createEarthEdges() {
        while (this.getSide().opposite().isToSideOf(this.getPlate().getCrust().getTopBoundary().getEdgeSample((Side)this.getSide()).getPosition().x, 700000.0f * (float)this.getSide().getSign())) {
            this.getPlate().addSection(this.getSide(), this.plate.getPlateType());
        }
    }

    protected void removeEarthEdges() {
        while (this.getSide().isToSideOf(this.getPlate().getCrust().getTopBoundary().getEdgeSample((Side)this.getSide()).getPosition().x, 700000.0f * (float)this.getSide().getSign())) {
            this.getPlate().removeSection(this.getSide());
        }
    }

    protected void moveMantleTopTo(float f) {
        for (Sample sample : this.getPlate().getMantle().getTopBoundary().samples) {
            sample.shiftWithTexture(new Vector3F(0.0f, f - sample.getPosition().y, 0.0f), this.plate.getTextureStrategy());
        }
        this.redistributeMantle();
    }

    protected void redistributeMantle() {
        Region region = this.getPlate().getMantle();
        for (int i = 0; i < region.getTopBoundary().samples.size(); ++i) {
            float f = region.getTopBoundary().samples.get((int)i).getPosition().y;
            float f2 = region.getBottomBoundary().samples.get((int)i).getPosition().y;
            for (int j = 1; j < region.getBoundaries().size() - 1; ++j) {
                float f3 = (float)j / (float)(region.getBoundaries().size() - 1);
                Sample sample = region.getBoundaries().get((int)j).samples.get(i);
                float f4 = f * (1.0f - f3) + f2 * f3;
                sample.shiftWithTexture(new Vector3F(0.0f, sample.getPosition().y - f4, 0.0f), this.plate.getTextureStrategy());
            }
        }
    }

    protected void onMagmaRemoved(MagmaRegion magmaRegion) {
    }

    public MagmaRegion addMagma(Vector2F vector2F, float f) {
        Vector2F vector2F2 = this.magmaTarget.minus(vector2F).normalized();
        float f2 = (float)Math.atan2(vector2F2.y, vector2F2.x);
        MagmaRegion magmaRegion = new MagmaRegion(this.plate.getTextureStrategy(), 1000.0f, f2, 6, vector2F);
        magmaRegion.alpha.set(Float.valueOf(f));
        this.plate.regions.add(magmaRegion);
        magmaRegion.moveToFront();
        this.magmaChamber.moveToFront();
        this.magmaBlobs.add(magmaRegion);
        return magmaRegion;
    }

    public void addMagma(Vector2F vector2F) {
        this.addMagma(vector2F, 0.0f);
    }

    protected void animateMagma(float f) {
        for (MagmaRegion magmaRegion : new LinkedList<MagmaRegion>(this.magmaBlobs)) {
            this.animateMagmaBlob(magmaRegion, f, true);
        }
    }

    protected void animateMagmaBlob(MagmaRegion magmaRegion, float f, boolean bl) {
        Vector2F vector2F = magmaRegion.position.get();
        Vector2F vector2F2 = this.magmaTarget.minus(vector2F).normalized();
        Vector2F vector2F3 = vector2F.plus(vector2F2.times(this.magmaSpeed * f));
        if (vector2F3.y > this.magmaTarget.y) {
            assert (this.plate.regions.contains(magmaRegion));
            this.plate.regions.remove(magmaRegion);
            assert (!this.plate.regions.contains(magmaRegion));
            assert (!this.plate.getModel().getRegions().contains(magmaRegion));
            this.magmaBlobs.remove(magmaRegion);
            magmaRegion.position.set(vector2F3);
            if (bl) {
                this.onMagmaRemoved(magmaRegion);
            }
        } else {
            if (magmaRegion.alpha.get().floatValue() < 1.0f) {
                magmaRegion.alpha.set(Float.valueOf(Math.min(1.0f, magmaRegion.alpha.get().floatValue() + 0.25f * f)));
            }
            magmaRegion.position.set(vector2F3);
        }
    }

    public static void recursiveSplitCall(VoidFunction1<Float> voidFunction1, float f, float f2) {
        if (f > f2) {
            PlateBehavior.recursiveSplitCall(voidFunction1, f / 2.0f, f2);
            PlateBehavior.recursiveSplitCall(voidFunction1, f / 2.0f, f2);
        } else {
            voidFunction1.apply(Float.valueOf(f));
        }
    }
}

