/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model.behaviors;

import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.platetectonics.model.PlateMotionModel;
import edu.colorado.phet.platetectonics.model.PlateMotionPlate;
import edu.colorado.phet.platetectonics.model.PlateType;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.SmokePuff;
import edu.colorado.phet.platetectonics.model.TerrainSample;
import edu.colorado.phet.platetectonics.model.behaviors.PlateBehavior;
import edu.colorado.phet.platetectonics.model.behaviors.SubductingBehavior;
import edu.colorado.phet.platetectonics.model.labels.BoundaryLabel;
import edu.colorado.phet.platetectonics.model.regions.MagmaRegion;
import edu.colorado.phet.platetectonics.model.regions.Region;
import edu.colorado.phet.platetectonics.util.Side;
import java.util.ArrayList;

public class OverridingBehavior
extends PlateBehavior {
    private float magmaCenterX;
    private float chamberFullness = 0.0f;
    private float minElevationInTimestep;
    private float maxElevationInTimestep;
    private final Sample fakeUnderSubductionSample;
    private float timeElapsed = 0.0f;
    private Region magmaTube;

    public OverridingBehavior(PlateMotionPlate plateMotionPlate, PlateMotionPlate plateMotionPlate2) {
        super(plateMotionPlate, plateMotionPlate2);
        this.getLithosphere().moveToFront();
        this.getCrust().moveToFront();
        plateMotionPlate.getModel().frontBoundarySideNotifier.updateListeners(plateMotionPlate.getSide());
        this.magmaCenterX = (float)this.getSide().getSign() * (plateMotionPlate2.getPlateType() == PlateType.YOUNG_OCEANIC ? 162105.25f : 103157.875f);
        this.magmaTarget = this.getMagmaChamberTop();
        this.magmaSpeed = 10000.0f;
        this.fakeUnderSubductionSample = new Sample(this.getFakeSubductionSamplePosition(), 0.0f, 0.0f, new Vector2F());
        Sample sample = plateMotionPlate.getLithosphere().getBottomBoundary().getEdgeSample(this.getSide().opposite());
        plateMotionPlate.getModel().joiningBoundaryLabel.getBoundary().replaceSample(sample, this.fakeUnderSubductionSample);
    }

    private Vector3F getFakeSubductionSamplePosition() {
        float f = this.getLithosphere().getBottomBoundary().getEdgeSample((Side)this.getSide().opposite()).getPosition().y;
        Vector3F vector3F = this.getOtherPlate().getLithosphere().getBottomBoundary().getEdgeSample(this.getSide()).getPosition();
        if (vector3F.y < f) {
            return vector3F;
        }
        return new Vector3F(vector3F.x, f, vector3F.z);
    }

    private float getMagmaChamberScale() {
        return this.plate.getPlateType().getCrustThickness() / (this.plate.getPlateType().isOceanic() ? 3.0f : 6.0f);
    }

    private SubductingBehavior getSubductingBehavior() {
        return (SubductingBehavior)this.getOtherPlate().getBehavior();
    }

    public void stepInTime(float f) {
        this.timeElapsed += f;
        if (this.magmaChamber == null) {
            this.magmaChamber = new MagmaRegion(this.plate.getTextureStrategy(), this.getMagmaChamberScale(), 1.5707964f, 16, this.getMagmaChamberTop());
            this.plate.regions.add(this.magmaChamber);
            this.magmaChamber.moveToFront();
            this.magmaChamber.setAllAlphas(0.0f);
            this.magmaTube = new Region(1, 2, new Function2<Integer, Integer, Sample>(){

                @Override
                public Sample apply(Integer n, Integer n2) {
                    float f = OverridingBehavior.this.magmaCenterX + (n2 == 0 ? -0.5f : 0.5f) * 1000.0f;
                    float f2 = ((OverridingBehavior)OverridingBehavior.this).getMagmaChamberTop().y - 500.0f;
                    return new Sample(new Vector3F(f, f2, 0.0f), PlateMotionModel.SIMPLE_MAGMA_TEMP, 2000.0f, OverridingBehavior.this.plate.getTextureStrategy().mapFront(new Vector2F(f, f2)));
                }
            });
            this.plate.regions.add(this.magmaTube);
            this.magmaTube.moveToFront();
            this.magmaTube.setAllAlphas(0.0f);
        }
        this.animateMagma(f);
        if (this.areMountainsRisingYet()) {
            this.animateMountains(f);
        }
        float f2 = this.getSubductingBehavior().getBoundaryElevation();
        Object object = this.getTopCrustBoundary().getEdgeSample(this.getOppositeSide());
        float f3 = ((Sample)object).getPosition().y;
        float f4 = f2 - f3;
        float f5 = (float)((double)f4 * (1.0 - Math.exp(-f)));
        int n = this.getOppositeSide().getIndex(this.getNumCrustXSamples());
        this.getCrust().layoutColumn(n, f3 + f5, this.getCrust().getBottomElevation(n) + f5, this.plate.getTextureStrategy(), true);
        this.getTerrain().shiftColumnElevation(n, f5);
        OverridingBehavior.recursiveSplitCall(new VoidFunction1<Float>(){

            @Override
            public void apply(Float f) {
                for (int i = 0; i < OverridingBehavior.this.getNumCrustXSamples(); ++i) {
                    float f2;
                    Sample sample = OverridingBehavior.this.getCrust().getTopBoundary().samples.get(i);
                    float f3 = sample.getPosition().y;
                    int n = 1;
                    if (i > 0) {
                        f3 += OverridingBehavior.this.getCrust().getTopBoundary().samples.get((int)(i - 1)).getPosition().y;
                        ++n;
                    }
                    if (i < OverridingBehavior.this.getNumCrustXSamples() - 1) {
                        f3 += OverridingBehavior.this.getCrust().getTopBoundary().samples.get((int)(i + 1)).getPosition().y;
                        ++n;
                    }
                    f3 /= (float)n;
                    float f4 = OverridingBehavior.this.getCrust().getTopElevation(i);
                    float f5 = f4 - (f2 = OverridingBehavior.this.getCrust().getBottomElevation(i));
                    float f6 = (f5 - 2.0f * (f4 - f3)) / f5;
                    if (f6 > 1.0f) {
                        f6 = 1.0f;
                    }
                    float f7 = Math.min(1.0f, Math.abs(sample.getPosition().x) / 50000.0f);
                    f6 = f7 + (1.0f - f7) * f6;
                    f6 = (float)Math.pow(f6, f.floatValue());
                    float f8 = (f4 + f2) / 2.0f;
                    f7 = (f4 - f8) * f6 + f8;
                    float f9 = f2 + (f7 - f4);
                    OverridingBehavior.this.getCrust().layoutColumn(i, f7, f9, OverridingBehavior.this.plate.getTextureStrategy(), true);
                    OverridingBehavior.this.getTerrain().shiftColumnElevation(i, f7 - f4);
                }
            }
        }, f, 0.1f);
        this.getTerrain().elevationChanged.updateListeners();
        final Vector2F vector2F = this.getSubductingBehavior().getLowestMeltingLocation();
        object = this.getSubductingBehavior().getHighestMeltingLocation();
        if (vector2F != null && object != null) {
            FunctionalUtils.repeat(new Runnable((Vector2F)object, f){
                final /* synthetic */ Vector2F val$highMeltPoint;
                final /* synthetic */ float val$millionsOfYears;
                {
                    this.val$highMeltPoint = vector2F2;
                    this.val$millionsOfYears = f;
                }

                public void run() {
                    Vector2F vector2F2 = vector2F.plus(this.val$highMeltPoint.minus(vector2F).times((float)Math.random()));
                    MagmaRegion magmaRegion = OverridingBehavior.this.addMagma(vector2F2, 0.7f);
                    OverridingBehavior.this.animateMagmaBlob(magmaRegion, (float)(Math.random() * (double)this.val$millionsOfYears), false);
                }
            }, this.samplePoisson(f * 1.0E-4f * vector2F.distance((AbstractVector2F)object)));
        }
        this.minElevationInTimestep = Float.MAX_VALUE;
        this.maxElevationInTimestep = -3.4028235E38f;
        for (Sample sample : this.getTopCrustBoundary().samples) {
            if (sample.getPosition().y > this.maxElevationInTimestep) {
                // empty if block
            }
            this.minElevationInTimestep = Math.min(this.minElevationInTimestep, sample.getPosition().y);
            this.maxElevationInTimestep = Math.max(this.maxElevationInTimestep, sample.getPosition().y);
        }
        if (this.areMountainsRisingYet()) {
            float f6 = 62831.85f;
            for (SmokePuff smokePuff : new ArrayList<SmokePuff>(this.plate.getModel().smokePuffs)) {
                this.agePuff(f, smokePuff);
            }
            this.createSmokeAt(new Vector3F(this.magmaCenterX, this.maxElevationInTimestep, 0.0f), f);
            this.createSmokeAt(new Vector3F(this.magmaCenterX - (float)this.plate.getSign() * 10000.0f, this.maxElevationInTimestep - 2000.0f, -f6), f);
            this.createSmokeAt(new Vector3F(this.magmaCenterX + (float)this.plate.getSign() * 10000.0f, this.maxElevationInTimestep - 2000.0f, -2.0f * f6), f);
            this.createSmokeAt(new Vector3F(this.magmaCenterX, this.maxElevationInTimestep - 2000.0f, -3.0f * f6), f);
            this.createSmokeAt(new Vector3F(this.magmaCenterX - (float)this.plate.getSign() * 10000.0f, this.maxElevationInTimestep - 4000.0f, -4.0f * f6), f);
            this.createSmokeAt(new Vector3F(this.magmaCenterX + (float)this.plate.getSign() * 10000.0f, this.maxElevationInTimestep - 4000.0f, -5.0f * f6), f);
            this.createSmokeAt(new Vector3F(this.magmaCenterX, this.maxElevationInTimestep - 4000.0f, -6.0f * f6), f);
            this.createSmokeAt(new Vector3F(this.magmaCenterX - (float)this.plate.getSign() * 10000.0f, this.maxElevationInTimestep - 6000.0f, -7.0f * f6), f);
            this.createSmokeAt(new Vector3F(this.magmaCenterX + (float)this.plate.getSign() * 10000.0f, this.maxElevationInTimestep - 6000.0f, -8.0f * f6), f);
            this.createSmokeAt(new Vector3F(this.magmaCenterX, this.maxElevationInTimestep - 6000.0f, -9.0f * f6), f);
            this.createSmokeAt(new Vector3F(this.magmaCenterX - (float)this.plate.getSign() * 10000.0f, this.maxElevationInTimestep - 8000.0f, -10.0f * f6), f);
            this.createSmokeAt(new Vector3F(this.magmaCenterX + (float)this.plate.getSign() * 10000.0f, this.maxElevationInTimestep - 8000.0f, -11.0f * f6), f);
        }
        this.magmaTube.setAllAlphas(this.areMountainsRisingYet() ? 1.0f : this.getChamberFullness());
        if (this.areMountainsRisingYet()) {
            float f7 = this.maxElevationInTimestep - 250.0f - this.magmaTube.getTopElevation(0);
            for (Sample sample : this.magmaTube.getTopBoundary().samples) {
                sample.setPosition(sample.getPosition().plus(new Vector3F(0.0f, f7, 0.0f)));
                sample.setTextureCoordinates(sample.getTextureCoordinates().plus(this.plate.getTextureStrategy().mapFrontDelta(new Vector2F(0.0f, f7))));
            }
            f4 = 10000.0f * f;
            for (Sample sample : this.magmaTube.getSamples()) {
                sample.setTextureCoordinates(sample.getTextureCoordinates().plus(this.plate.getTextureStrategy().mapFrontDelta(new Vector2F(0.0f, -f4))));
            }
        }
        BoundaryLabel boundaryLabel = this.getPlate().getBoundaryLabel();
        Property<Float> property = this.getSide() == Side.LEFT ? boundaryLabel.maxX : boundaryLabel.minX;
        f5 = this.getOtherPlate().getLithosphere().getBottomBoundary().getEdgeSample((Side)this.getSide()).getPosition().x;
        float f8 = 55000.0f;
        if (Math.abs(f5) > f8) {
            f5 = Math.signum(f5) * f8;
        }
        property.set(Float.valueOf(f5));
        this.fakeUnderSubductionSample.setPosition(this.getFakeSubductionSamplePosition());
    }

    private void agePuff(float f, SmokePuff smokePuff) {
        smokePuff.age += f;
        float f2 = -smokePuff.age * smokePuff.age / 4.0f + smokePuff.age;
        if (f2 < 0.0f) {
            this.plate.getModel().smokePuffs.remove(smokePuff);
        } else {
            smokePuff.scale.set(Float.valueOf((float)Math.sqrt(smokePuff.age)));
            smokePuff.alpha.set(Float.valueOf(f2 / 15.0f));
            Vector3F vector3F = new Vector3F(0.0f, f * 2000.0f, 0.0f);
            final Property<Integer> property = new Property<Integer>(0);
            final Property<Double> property2 = new Property<Double>(0.0);
            final Property<Double> property3 = new Property<Double>(0.0);
            OverridingBehavior.recursiveSplitCall(new VoidFunction1<Float>(){

                @Override
                public void apply(Float f) {
                    property.set((Integer)property.get() + 1);
                    property2.set((Double)property2.get() + Math.random());
                    property3.set((Double)property3.get() + Math.random());
                }
            }, f, 0.1f);
            property2.set(property2.get() / (double)property.get().intValue());
            property3.set(property3.get() / (double)property.get().intValue());
            Vector3F vector3F2 = new Vector3F((float)((property2.get() - 0.5) * 800.0), (float)((property3.get() - 0.5) * 100.0), 0.0f).times(f * 15.0f);
            smokePuff.position.set(smokePuff.position.get().plus(vector3F.plus(vector3F2)));
        }
    }

    private int samplePoisson(float f) {
        double d = Math.exp(-f);
        int n = 0;
        double d2 = 1.0;
        do {
            ++n;
        } while ((d2 *= Math.random()) > d);
        return n - 1;
    }

    private float getChamberFullness() {
        float f;
        boolean bl = this.getOtherPlate().getPlateType() == PlateType.YOUNG_OCEANIC;
        float f2 = bl ? 22.0f : 18.5f;
        float f3 = f = bl ? 26.5f : 24.0f;
        if (this.getPlate().getPlateType().isOceanic()) {
            f = (f - f2) / 5.0f + f2;
        }
        if (this.timeElapsed < f2) {
            return 0.0f;
        }
        if (this.timeElapsed > f) {
            return 1.0f;
        }
        return (this.timeElapsed - f2) / (f - f2);
    }

    private boolean areMountainsRisingYet() {
        return (double)this.timeElapsed >= (this.getOtherPlate().getPlateType() == PlateType.YOUNG_OCEANIC ? 26.5 : 24.0);
    }

    private void createSmokeAt(final Vector3F vector3F, final float f) {
        if (this.maxElevationInTimestep < 0.0f) {
            return;
        }
        FunctionalUtils.repeat(new Runnable(){

            public void run() {
                SmokePuff smokePuff = new SmokePuff(){
                    {
                        this.position.set(vector3F);
                        this.scale.set(Float.valueOf(0.1f));
                        this.alpha.set(Float.valueOf(0.0f));
                    }
                };
                OverridingBehavior.this.plate.getModel().smokePuffs.add(smokePuff);
                OverridingBehavior.this.agePuff((float)(Math.random() * (double)f), smokePuff);
            }
        }, this.samplePoisson(f * 8.0f));
    }

    private void animateMountains(float f) {
        assert (this.getNumCrustXSamples() == this.getNumTerrainXSamples());
        for (int i = 0; i < this.getNumTerrainXSamples(); ++i) {
            float f2 = this.getTerrain().xPositions.get(i).floatValue();
            for (int j = 0; j < this.getTerrain().getNumRows(); ++j) {
                float f3 = this.getTerrain().zPositions.get(j).floatValue() / 10000.0f;
                float f4 = (float)(Math.cos(f3) + 1.0) / 2.0f;
                float f5 = (float)Math.abs((double)f3 / Math.PI);
                int n = (int)(f5 + 0.5f) % 3;
                float f6 = f2 + (n == 0 ? 0.0f : (float)(-this.plate.getSign()) * 10000.0f * (float)(n == 1 ? 1 : -1));
                float f7 = (float)Math.exp(-Math.abs(f6 - this.magmaCenterX) / 10000.0f) * 400.0f * f;
                float f8 = (float)Math.exp(-Math.abs(f6 - this.magmaCenterX) / 30000.0f) * 500.0f * f;
                TerrainSample terrainSample = this.getTerrain().getSample(i, j);
                float f9 = f7 * f4 * f4 * f4;
                terrainSample.setElevation(terrainSample.getElevation() + f9);
                if (j != this.getTerrain().getFrontZIndex()) continue;
                float f10 = this.getCrust().getTopElevation(i) + f9;
                float f11 = this.getCrust().getBottomElevation(i) - f8;
                float f12 = this.getLithosphere().getBottomElevation(i) - f8 * 2.0f;
                this.getCrust().layoutColumn(i, f10, f11, this.plate.getTextureStrategy(), true);
                this.getLithosphere().layoutColumn(i, f11, f12, this.plate.getTextureStrategy(), true);
            }
        }
    }

    private Vector2F getMagmaChamberTop() {
        return new Vector2F(this.magmaCenterX, this.plate.getPlateType().getCrustTopY());
    }

    protected void onMagmaRemoved(MagmaRegion magmaRegion) {
        super.onMagmaRemoved(magmaRegion);
        this.chamberFullness = Math.min(1.0f, this.chamberFullness + (this.plate.getPlateType().isContinental() ? 0.05f : 0.25f));
        this.magmaChamber.setAllAlphas(this.getChamberFullness());
    }
}

