/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.platetectonics.model.TextureStrategy;

public class Sample {
    private Vector3F position;
    private float temperature;
    private float density;
    private Vector2F textureCoordinates;
    private float randomTerrainOffset = 0.0f;

    public Sample(Vector3F vector3F, float f, float f2, Vector2F vector2F) {
        this.position = vector3F;
        this.temperature = f;
        this.density = f2;
        this.textureCoordinates = vector2F;
    }

    public void shiftWithTexture(Vector3F vector3F, TextureStrategy textureStrategy) {
        this.setPosition(this.getPosition().plus(vector3F));
        this.setTextureCoordinates(this.getTextureCoordinates().plus(textureStrategy.mapFrontDelta(new Vector2F(vector3F.x, vector3F.y))));
    }

    public Vector3F getPosition() {
        return this.position;
    }

    public void setPosition(Vector3F vector3F) {
        this.position = vector3F;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float f) {
        this.temperature = f;
    }

    public float getDensity() {
        return this.density;
    }

    public void setDensity(float f) {
        this.density = f;
    }

    public Vector2F getTextureCoordinates() {
        return this.textureCoordinates;
    }

    public void setTextureCoordinates(Vector2F vector2F) {
        this.textureCoordinates = vector2F;
    }

    public float getRandomTerrainOffset() {
        return this.randomTerrainOffset;
    }

    public void setRandomTerrainOffset(float f) {
        this.randomTerrainOffset = f;
    }
}

