/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model;

import edu.colorado.phet.platetectonics.PlateTectonicsResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlateType
extends Enum<PlateType> {
    public static final /* enum */ PlateType CONTINENTAL = new PlateType(true, false, 2750.0f, 3500.0f, -40000.0f, 70000.0f, PlateTectonicsResources.Strings.CONTINENTAL_CRUST);
    public static final /* enum */ PlateType YOUNG_OCEANIC = new PlateType(false, true, 3000.0f, -4000.0f, -10000.0f, 45000.0f, PlateTectonicsResources.Strings.YOUNG_OCEANIC_CRUST);
    public static final /* enum */ PlateType OLD_OCEANIC = new PlateType(false, true, 3070.0f, -4000.0f, -10000.0f, 55000.0f, PlateTectonicsResources.Strings.OLD_OCEANIC_CRUST);
    private final boolean continental;
    private final boolean oceanic;
    private final float density;
    private final float crustTopY;
    private final float crustBottomY;
    private final float mantleLithosphereThickness;
    private final String specificLabel;
    private static final /* synthetic */ PlateType[] $VALUES;

    public static PlateType[] values() {
        return (PlateType[])$VALUES.clone();
    }

    private PlateType(boolean bl, boolean bl2, float f, float f2, float f3, float f4, String string2) {
        this.continental = bl;
        this.oceanic = bl2;
        this.density = f;
        this.crustTopY = f2;
        this.crustBottomY = f3;
        this.mantleLithosphereThickness = f4;
        this.specificLabel = string2;
    }

    public boolean isContinental() {
        return this.continental;
    }

    public boolean isOceanic() {
        return this.oceanic;
    }

    public float getDensity() {
        return this.density;
    }

    public float getCrustTopY() {
        return this.crustTopY;
    }

    public float getCrustBottomY() {
        return this.crustBottomY;
    }

    public float getMantleLithosphereThickness() {
        return this.mantleLithosphereThickness;
    }

    public float getLithosphereBottomY() {
        return this.getCrustBottomY() - this.getMantleLithosphereThickness();
    }

    public float getCrustThickness() {
        return this.getCrustTopY() - this.getCrustBottomY();
    }

    public float getLithosphereThickness() {
        return this.getCrustTopY() - this.getLithosphereBottomY();
    }

    public String getSpecificLabel() {
        return this.specificLabel;
    }

    static {
        $VALUES = new PlateType[]{CONTINENTAL, YOUNG_OCEANIC, OLD_OCEANIC};
    }
}

