/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.model;

import edu.colorado.phet.common.phetcommon.math.Bounds3F;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.Ray3F;
import edu.colorado.phet.common.phetcommon.math.Triangle3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.Notifier;
import edu.colorado.phet.common.phetcommon.model.event.VoidNotifier;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.platetectonics.model.Plate;
import edu.colorado.phet.platetectonics.model.Sample;
import edu.colorado.phet.platetectonics.model.Terrain;
import edu.colorado.phet.platetectonics.model.TextureStrategy;
import edu.colorado.phet.platetectonics.model.regions.CrossSectionStrip;
import edu.colorado.phet.platetectonics.model.regions.Region;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlateTectonicsModel {
    public final VoidNotifier modelChanged = new VoidNotifier();
    public final Notifier<CrossSectionStrip> crossSectionStripAdded = new Notifier();
    public final Notifier<CrossSectionStrip> crossSectionStripRemoved = new Notifier();
    public final Notifier<Terrain> terrainAdded = new Notifier();
    public final Notifier<Terrain> terrainRemoved = new Notifier();
    public final Notifier<Plate> plateAdded = new Notifier();
    public final Notifier<Plate> plateRemoved = new Notifier();
    public final Notifier<Region> regionAdded = new Notifier();
    public final Notifier<Region> regionRemoved = new Notifier();
    public final Bounds3F bounds;
    private final TextureStrategy textureStrategy;
    private final List<Plate> plates = new ArrayList<Plate>();
    private final List<Region> regions = new ArrayList<Region>();
    private final List<CrossSectionStrip> crossSectionStrips = new ArrayList<CrossSectionStrip>();
    private final List<Terrain> terrains = new ArrayList<Terrain>();
    private final VoidFunction1<Region> regionOnPlateAddedListener = new VoidFunction1<Region>(){

        @Override
        public void apply(Region region) {
            PlateTectonicsModel.this.addRegion(region);
        }
    };
    private final VoidFunction1<Region> regionOnPlateRemovedListener = new VoidFunction1<Region>(){

        @Override
        public void apply(Region region) {
            PlateTectonicsModel.this.removeRegion(region);
        }
    };
    public final Notifier<Vector3F> debugPing = new Notifier();
    public static float ZERO_CELSIUS = 293.15f;
    public static final double DEEP_OCEAN_TEMPERATURE = ZERO_CELSIUS + 4.0f;
    public static Function.LinearFunction water200to1000 = new Function.LinearFunction(-1000.0, -200.0, DEEP_OCEAN_TEMPERATURE, PlateTectonicsModel.getAirTemperature(0.0));
    public static final float MAX_FLAT_X = (float)((double)Math.abs(-6371000.0f) * Math.PI);
    public static final Vector3F EARTH_CENTER = new Vector3F(0.0f, -6371000.0f, 0.0f);
    public static final Vector3F RADIAL_Z_0 = new Vector3F(1.0f, 1.0f, 0.0f);

    protected PlateTectonicsModel(Bounds3F bounds3F, TextureStrategy textureStrategy) {
        this.bounds = bounds3F;
        this.textureStrategy = textureStrategy;
    }

    public abstract double getDensity(double var1, double var3);

    public abstract double getTemperature(double var1, double var3);

    public double rayTraceDensity(Ray3F ray3F, LWJGLTransform lWJGLTransform, boolean bl) {
        for (Terrain terrain : this.terrains) {
            Option<Vector3F> option = terrain.intersectWithRay(ray3F, lWJGLTransform);
            if (!option.isSome()) continue;
            Vector3F vector3F = PlateTectonicsModel.convertToPlanar(lWJGLTransform.inversePosition(option.get()));
            if (vector3F.y < 0.0f) {
                if (bl) {
                    return PlateTectonicsModel.getWaterDensity(0.0);
                }
                return 2720.0;
            }
            return 2720.0;
        }
        return 0.0;
    }

    public Bounds3F getBounds() {
        return this.bounds;
    }

    public void update(double d) {
    }

    public void resetAll() {
    }

    public void addPlate(Plate plate) {
        this.plates.add(plate);
        plate.regions.addElementAddedObserver(this.regionOnPlateAddedListener, false);
        plate.regions.addElementRemovedObserver(this.regionOnPlateRemovedListener);
        this.plateAdded.updateListeners(plate);
        for (Region region : plate.regions) {
            this.addRegion(region);
        }
        this.addTerrain(plate.getTerrain());
    }

    public void removePlate(Plate plate) {
        this.plates.remove(plate);
        plate.regions.removeElementAddedObserver(this.regionOnPlateAddedListener);
        plate.regions.removeElementRemovedObserver(this.regionOnPlateRemovedListener);
        this.plateRemoved.updateListeners(plate);
        plate.disposed.updateListeners();
        for (Region region : plate.regions) {
            this.removeRegion(region);
        }
        this.removeTerrain(plate.getTerrain());
    }

    public void addRegion(Region region) {
        this.regions.add(region);
        this.regionAdded.updateListeners(region);
        for (CrossSectionStrip crossSectionStrip : region.getStrips()) {
            this.addStrip(crossSectionStrip);
        }
    }

    public void removeRegion(Region region) {
        assert (this.regions.contains(region));
        this.regions.remove(region);
        this.regionRemoved.updateListeners(region);
        region.disposed.updateListeners();
        for (CrossSectionStrip crossSectionStrip : region.getStrips()) {
            this.removeStrip(crossSectionStrip);
        }
    }

    public void addStrip(CrossSectionStrip crossSectionStrip) {
        assert (!this.crossSectionStrips.contains(crossSectionStrip));
        this.crossSectionStrips.add(crossSectionStrip);
        this.crossSectionStripAdded.updateListeners(crossSectionStrip);
    }

    public void addTerrain(Terrain terrain) {
        assert (!this.terrains.contains(terrain));
        this.terrains.add(terrain);
        this.terrainAdded.updateListeners(terrain);
    }

    public void removeStrip(CrossSectionStrip crossSectionStrip) {
        assert (this.crossSectionStrips.contains(crossSectionStrip));
        this.crossSectionStrips.remove(crossSectionStrip);
        this.crossSectionStripRemoved.updateListeners(crossSectionStrip);
        crossSectionStrip.disposed.updateListeners();
    }

    public void removeTerrain(Terrain terrain) {
        assert (this.terrains.contains(terrain));
        this.terrains.remove(terrain);
        this.terrainRemoved.updateListeners(terrain);
        terrain.disposed.updateListeners();
    }

    public List<CrossSectionStrip> getCrossSectionStrips() {
        return this.crossSectionStrips;
    }

    public List<Terrain> getTerrains() {
        return this.terrains;
    }

    public TextureStrategy getTextureStrategy() {
        return this.textureStrategy;
    }

    public static double getAirTemperature(double d) {
        assert (d >= 0.0);
        return Math.max(0.0, (double)(ZERO_CELSIUS + 15.0f) - 15.0 * d / 2500.0);
    }

    public static double getAirDensity(double d) {
        double d2 = 101.325 * Math.pow(1.0 - 0.0065 * d / 288.15, 5.25221728828453);
        double d3 = d2 * 0.0289644 / (8.31447 * PlateTectonicsModel.getAirTemperature(d));
        return Double.isNaN(d3) ? 0.0 : d3;
    }

    public static double getWaterDensity(double d) {
        if (d > -1000.0) {
            return 1025.0 + 3.0 * (d / -1000.0);
        }
        return 1028.0;
    }

    public static double getWaterTemperature(double d) {
        assert (d <= 0.0);
        if (d > -200.0) {
            return PlateTectonicsModel.getAirTemperature(0.0);
        }
        if (d > -1000.0) {
            return water200to1000.evaluate(d);
        }
        return DEEP_OCEAN_TEMPERATURE;
    }

    public static Vector3F convertToRadial(Vector3F vector3F) {
        return PlateTectonicsModel.convertToRadial(PlateTectonicsModel.getXRadialVector(vector3F.x), PlateTectonicsModel.getZRadialVector(vector3F.z), vector3F.y);
    }

    public static Vector3F convertToRadial(Vector3F vector3F, Vector3F vector3F2, float f) {
        float f2 = f + 6371000.0f;
        return vector3F.componentTimes(vector3F2).times(f2).plus(EARTH_CENTER);
    }

    public static Vector3F convertToRadial(float f, float f2) {
        return PlateTectonicsModel.convertToRadial(PlateTectonicsModel.getXRadialVector(f), f2);
    }

    public static Vector3F convertToRadial(Vector3F vector3F, float f) {
        return PlateTectonicsModel.convertToRadial(vector3F, RADIAL_Z_0, f);
    }

    public static Vector3F getXRadialVector(float f) {
        float f2 = 1.5707964f - f / 6371000.0f;
        return new Vector3F((float)Math.cos(f2), (float)Math.sin(f2), 1.0f);
    }

    public static Vector3F getZRadialVector(float f) {
        float f2 = 1.5707964f - f / 6371000.0f;
        float f3 = (float)Math.sin(f2);
        return new Vector3F(f3, f3, (float)Math.cos(f2));
    }

    public static Vector3F convertToPlanar(Vector3F vector3F) {
        Vector3F vector3F2 = vector3F.minus(EARTH_CENTER);
        float f = vector3F2.magnitude();
        float f2 = (float)Math.acos(vector3F2.z / f);
        float f3 = (float)Math.atan2(vector3F2.y, vector3F2.x);
        double d = 1.5707963267948966 - (double)f3;
        if (d > Math.PI) {
            d -= Math.PI * 2;
        }
        return new Vector3F((float)(d * 6371000.0), f - 6371000.0f, (float)((1.5707963267948966 - (double)f2) * 6371000.0));
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    public abstract List<CrossSectionStrip> getStripsInOrder();

    protected HitResult firstStripIntersection(Vector3F vector3F) {
        List<CrossSectionStrip> list = this.getStripsInOrder();
        for (CrossSectionStrip crossSectionStrip : list) {
            for (int i = 0; i < crossSectionStrip.getLength() - 1; ++i) {
                HitResult hitResult = PlateTectonicsModel.triangleXYIntersection(crossSectionStrip.topPoints.get(i), crossSectionStrip.bottomPoints.get(i), crossSectionStrip.topPoints.get(i + 1), vector3F);
                if (hitResult != null) {
                    return hitResult;
                }
                HitResult hitResult2 = PlateTectonicsModel.triangleXYIntersection(crossSectionStrip.bottomPoints.get(i), crossSectionStrip.topPoints.get(i + 1), crossSectionStrip.bottomPoints.get(i + 1), vector3F);
                if (hitResult2 == null) continue;
                return hitResult2;
            }
        }
        return null;
    }

    private static HitResult triangleXYIntersection(Sample sample, Sample sample2, Sample sample3, Vector3F vector3F) {
        boolean bl = new Triangle3F(sample.getPosition(), sample2.getPosition(), sample3.getPosition()).intersectWith(new Ray3F(vector3F, Vector3F.Z_UNIT)).isSome();
        if (!bl) {
            return null;
        }
        float f = PlateTectonicsModel.triangleXYArea(vector3F, sample2.getPosition(), sample3.getPosition());
        float f2 = PlateTectonicsModel.triangleXYArea(vector3F, sample3.getPosition(), sample.getPosition());
        float f3 = PlateTectonicsModel.triangleXYArea(vector3F, sample.getPosition(), sample2.getPosition());
        float f4 = PlateTectonicsModel.triangleXYArea(sample.getPosition(), sample2.getPosition(), sample3.getPosition());
        return new HitResult(f / f4 * sample.getDensity() + f2 / f4 * sample2.getDensity() + f3 / f4 * sample3.getDensity(), f / f4 * sample.getTemperature() + f2 / f4 * sample2.getTemperature() + f3 / f4 * sample3.getTemperature());
    }

    private static float triangleXYArea(Vector3F vector3F, Vector3F vector3F2, Vector3F vector3F3) {
        return Math.abs(((vector3F.x - vector3F3.x) * (vector3F2.y - vector3F3.y) - (vector3F2.x - vector3F3.x) * (vector3F.y - vector3F3.y)) / 2.0f);
    }

    protected static class HitResult {
        public final float density;
        public final float temperature;

        private HitResult(float f, float f2) {
            this.density = f;
            this.temperature = f2;
        }
    }
}

