/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.control;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.ValueNotifier;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.piccolophet.nodes.RulerNode;
import edu.colorado.phet.lwjglphet.LWJGLCursorHandler;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.ThreadedPlanarPiccoloNode;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import edu.colorado.phet.platetectonics.control.DraggableTool2D;
import edu.colorado.phet.platetectonics.model.ToolboxState;
import edu.colorado.phet.platetectonics.tabs.PlateMotionTab;
import edu.colorado.phet.platetectonics.tabs.PlateTectonicsTab;
import edu.colorado.phet.platetectonics.util.MortalSimpleObserver;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Cursor;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulerNode3D
extends ThreadedPlanarPiccoloNode
implements DraggableTool2D {
    public final ValueNotifier<RulerNode3D> disposed = new ValueNotifier<RulerNode3D>(this);
    private final LWJGLTransform modelViewTransform;
    private final PlateTectonicsTab tab;
    private int zoomMultiplier = 1;
    public Vector2F draggedPosition = new Vector2F();

    public RulerNode3D(LWJGLTransform lWJGLTransform, final PlateTectonicsTab plateTectonicsTab) {
        super(new RulerNode2D(lWJGLTransform.transformDeltaX(1000.0f), plateTectonicsTab){
            {
                super(f, plateTectonicsTab3);
                this.scale(RulerNode3D.scaleMultiplier(plateTectonicsTab));
            }
        });
        this.modelViewTransform = lWJGLTransform;
        this.tab = plateTectonicsTab;
        plateTectonicsTab.zoomRatio.addObserver(new MortalSimpleObserver(plateTectonicsTab.zoomRatio, this.disposed){

            public void update() {
                Object object;
                int n = RulerNode3D.this.getScale();
                if (n != RulerNode3D.this.zoomMultiplier) {
                    RulerNode3D.this.zoomMultiplier = n;
                    object = (RulerNode2D)RulerNode3D.this.getNode();
                    ((RulerNode2D)object).setMajorTickLabels(RulerNode3D.getLabels(RulerNode3D.scaleMultiplier(plateTectonicsTab) * RulerNode3D.this.zoomMultiplier));
                    RulerNode3D.this.repaint();
                }
                object = Matrix4F.scaling((float)RulerNode3D.this.zoomMultiplier / 4.0f);
                Matrix4F matrix4F = Matrix4F.translation(RulerNode3D.this.draggedPosition.x, RulerNode3D.this.draggedPosition.y, 0.0f);
                RulerNode3D.this.transform.set(matrix4F.times((Matrix4F)object).times(Matrix4F.translation(0.0f, -((float)RulerNode3D.this.getNode().getFullBounds().getHeight()), 0.0f)));
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public int getScale() {
        int n = 1;
        float f = 1.3f;
        float f2 = this.tab.getSceneDistanceZoomFactor();
        while (f2 > f) {
            n *= 2;
            if ((f2 /= 2.0f) < f) break;
            f2 = (float)((double)f2 / 2.5);
            n = (int)((double)n * 2.5);
            if (f2 < f) break;
            f2 /= 2.0f;
            n *= 2;
            f = 1.0f + (f - 1.0f) * (f - 1.0f);
        }
        return n;
    }

    @Override
    public boolean allowsDrag(Vector2F vector2F) {
        return true;
    }

    @Override
    public void dragDelta(Vector2F vector2F) {
        this.transform.prepend(Matrix4F.translation(vector2F.x, vector2F.y, 0.0f));
        this.draggedPosition = this.draggedPosition.plus(vector2F);
    }

    @Override
    public Property<Boolean> getInsideToolboxProperty(ToolboxState toolboxState) {
        return toolboxState.rulerInToolbox;
    }

    public Vector2F getInitialMouseOffset() {
        return new Vector2F(10.0f, -10.0f);
    }

    @Override
    public IUserComponent getUserComponent() {
        return PlateTectonicsSimSharing.UserComponents.ruler;
    }

    @Override
    public Vector3F getSensorModelPosition() {
        return this.modelViewTransform.inversePosition(this.getSensorViewPosition());
    }

    @Override
    public Vector3F getSensorViewPosition() {
        return new Vector3F(this.draggedPosition.x, this.draggedPosition.y, 0.0f);
    }

    @Override
    public ParameterSet getCustomParameters() {
        return new ParameterSet();
    }

    @Override
    public void recycle() {
        super.recycle();
        this.getParent().removeChild(this);
        this.disposed.updateListeners();
    }

    private static String[] getLabels(final int n) {
        List<String> list = FunctionalUtils.map(FunctionalUtils.rangeInclusive(0, 10), new Function1<Integer, String>(){

            @Override
            public String apply(Integer n2) {
                return Integer.toString(n2 * 10 * n);
            }
        });
        Collections.reverse(list);
        String[] stringArray = new String[list.size()];
        return list.toArray(stringArray);
    }

    private static int scaleMultiplier(PlateTectonicsTab plateTectonicsTab) {
        return plateTectonicsTab instanceof PlateMotionTab ? 4 : 1;
    }

    public static class RulerNode2D
    extends RulerNode {
        public RulerNode2D(float f, PlateTectonicsTab plateTectonicsTab) {
            super(300.0, 30.0, RulerNode3D.getLabels(RulerNode3D.scaleMultiplier(plateTectonicsTab)), "", 1, 9);
            this.addChild(new PText(PlateTectonicsResources.Strings.RULER_UNITS){
                {
                    this.setFont(RulerNode.createDefaultFont(9));
                    this.rotate(1.5707963267948966);
                    this.setOffset(295.0, (30.0 - this.getFullBounds().getWidth()) / 2.0);
                }
            });
            this.rotate(-1.5707963267948966);
            this.scale(4.0f * f / 3.0f);
            this.setInsetWidth(0.0);
            this.addInputEventListener(new LWJGLCursorHandler());
        }

        public void setMajorTickLabels(String[] stringArray) {
            super.setMajorTickLabels(stringArray);
            this.repaint();
        }
    }
}

