/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.control;

import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJRadioButton;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.Spacer;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.platetectonics.PlateTectonicsConstants;
import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import edu.colorado.phet.platetectonics.PlateTectonicsSimSharing;
import edu.colorado.phet.platetectonics.model.PlateMotionModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class MotionTypeChooserPanel
extends PNode {
    private Property<PlateMotionModel.MotionType> motionType;
    private PlateMotionModel plateModel;

    public MotionTypeChooserPanel(PlateMotionModel plateMotionModel) {
        this.plateModel = plateMotionModel;
        this.motionType = plateMotionModel.motionType;
        boolean bl = plateMotionModel.allowsDivergentMotion();
        boolean bl2 = plateMotionModel.allowsConvergentMotion();
        boolean bl3 = plateMotionModel.allowsTransformMotion();
        PSwing pSwing = new PSwing(new MotionTypeChooserRadioButton(PlateTectonicsSimSharing.UserComponents.convergentMotion, PlateTectonicsResources.Strings.CONVERGENT, PlateMotionModel.MotionType.CONVERGENT));
        PSwing pSwing2 = new PSwing(new MotionTypeChooserRadioButton(PlateTectonicsSimSharing.UserComponents.divergentMotion, PlateTectonicsResources.Strings.DIVERGENT, PlateMotionModel.MotionType.DIVERGENT));
        PSwing pSwing3 = new PSwing(new MotionTypeChooserRadioButton(PlateTectonicsSimSharing.UserComponents.transformMotion, PlateTectonicsResources.Strings.TRANSFORM, PlateMotionModel.MotionType.TRANSFORM));
        final Property<Double> property = new Property<Double>(0.0);
        if (bl2) {
            pSwing.setOffset(property.get() + (100.0 - pSwing.getFullBounds().getWidth()) / 2.0, 60.0);
            this.addChild(pSwing);
            this.addChild(new Spacer(property.get(), 0.0, 100.0, 50.0));
            this.addChild(new IconArrow(new Point2D.Double(2.0, 0.0), new Point2D.Double(45.0, 0.0)){
                {
                    super(point2D, point2D2);
                    this.setOffset((Double)property.get(), 25.0);
                    this.setPaint(PlateTectonicsConstants.ARROW_CONVERGENT_FILL);
                }
            });
            this.addChild(new IconArrow(new Point2D.Double(98.0, 0.0), new Point2D.Double(55.0, 0.0)){
                {
                    super(point2D, point2D2);
                    this.setOffset((Double)property.get(), 25.0);
                    this.setPaint(PlateTectonicsConstants.ARROW_CONVERGENT_FILL);
                }
            });
            property.set(property.get() + 100.0 + 10.0);
        }
        if (bl) {
            pSwing2.setOffset(property.get() + (100.0 - pSwing2.getFullBounds().getWidth()) / 2.0, 60.0);
            this.addChild(pSwing2);
            this.addChild(new Spacer(property.get(), 0.0, 100.0, 50.0));
            this.addChild(new IconArrow(new Point2D.Double(45.0, 0.0), new Point2D.Double(2.0, 0.0)){
                {
                    super(point2D, point2D2);
                    this.setOffset((Double)property.get(), 25.0);
                    this.setPaint(PlateTectonicsConstants.ARROW_DIVERGENT_FILL);
                }
            });
            this.addChild(new IconArrow(new Point2D.Double(55.0, 0.0), new Point2D.Double(98.0, 0.0)){
                {
                    super(point2D, point2D2);
                    this.setOffset((Double)property.get(), 25.0);
                    this.setPaint(PlateTectonicsConstants.ARROW_DIVERGENT_FILL);
                }
            });
            property.set(property.get() + 100.0 + 10.0);
        }
        if (bl3) {
            pSwing3.setOffset(property.get() + (100.0 - pSwing3.getFullBounds().getWidth()) / 2.0, 60.0);
            this.addChild(pSwing3);
            this.addChild(new Spacer(property.get(), 0.0, 100.0, 50.0));
            double d = property.get() + 50.0;
            final AffineTransform affineTransform = new AffineTransform(1.0, 0.0, (double)-0.6f, 1.0, 15.000000596046448, 0.0);
            this.addChild(new IconArrow((Point2D)new Point2D.Double(d, 20.0), new Point2D.Double(d, 2.0), 8.0){
                {
                    super(point2D, point2D2, d);
                    this.setPaint(PlateTectonicsConstants.ARROW_TRANSFORM_FILL);
                    this.setTransform(affineTransform);
                }
            });
            this.addChild(new IconArrow((Point2D)new Point2D.Double(d, 30.0), new Point2D.Double(d, 48.0), 8.0){
                {
                    super(point2D, point2D2, d);
                    this.setPaint(PlateTectonicsConstants.ARROW_TRANSFORM_FILL);
                    this.setTransform(affineTransform);
                }
            });
            property.set(property.get() + 100.0 + 10.0);
        }
    }

    private boolean typeEquals(PlateMotionModel.MotionType motionType, PlateMotionModel.MotionType motionType2) {
        if (motionType2 == null) {
            if (this.plateModel.allowsConvergentMotion()) {
                return motionType == PlateMotionModel.MotionType.CONVERGENT;
            }
            if (this.plateModel.allowsDivergentMotion()) {
                return motionType == PlateMotionModel.MotionType.DIVERGENT;
            }
            return motionType == PlateMotionModel.MotionType.TRANSFORM;
        }
        return motionType == motionType2;
    }

    private static class IconArrow
    extends ArrowNode {
        public IconArrow(Point2D point2D, Point2D point2D2) {
            this(point2D, point2D2, 14.0);
        }

        public IconArrow(Point2D point2D, Point2D point2D2, double d) {
            super(point2D, point2D2, d, 14.0, 8.0);
            this.setStrokePaint(Color.BLACK);
            this.setStroke(new BasicStroke(1.0f));
        }
    }

    private class MotionTypeChooserRadioButton
    extends SimSharingJRadioButton {
        private MotionTypeChooserRadioButton(IUserComponent iUserComponent, String string, final PlateMotionModel.MotionType motionType) {
            super(iUserComponent, string);
            if (((MotionTypeChooserPanel)MotionTypeChooserPanel.this).plateModel.animationStarted.get().booleanValue()) {
                this.setSelected(MotionTypeChooserPanel.this.typeEquals(motionType, (PlateMotionModel.MotionType)((Object)MotionTypeChooserPanel.this.motionType.get())));
            } else {
                this.setSelected(MotionTypeChooserPanel.this.typeEquals(motionType, ((MotionTypeChooserPanel)MotionTypeChooserPanel.this).plateModel.motionTypeIfStarted.get()));
            }
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LWJGLUtils.invoke(new Runnable(){

                        public void run() {
                            ((MotionTypeChooserPanel)MotionTypeChooserPanel.this).plateModel.motionTypeIfStarted.set(motionType);
                        }
                    });
                    MotionTypeChooserRadioButton.this.setSelected(true);
                }
            });
            ((MotionTypeChooserPanel)MotionTypeChooserPanel.this).plateModel.motionTypeIfStarted.addObserver(new ChangeObserver<PlateMotionModel.MotionType>(){

                @Override
                public void update(PlateMotionModel.MotionType motionType3, PlateMotionModel.MotionType motionType2) {
                    final boolean bl = MotionTypeChooserPanel.this.typeEquals(motionType, motionType3);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MotionTypeChooserRadioButton.this.setSelected(bl);
                        }
                    });
                }
            });
            ((MotionTypeChooserPanel)MotionTypeChooserPanel.this).plateModel.animationStarted.addObserver(new SimpleObserver(){

                public void update() {
                    final boolean bl = ((MotionTypeChooserPanel)MotionTypeChooserPanel.this).plateModel.animationStarted.get() == false;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MotionTypeChooserRadioButton.this.setEnabled(bl);
                        }
                    });
                }
            });
        }
    }
}

