/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.menu.OptionsMenu;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PhetTabbedPane;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import edu.colorado.phet.lwjglphet.LWJGLPhetApplication;
import edu.colorado.phet.lwjglphet.StartupUtils;
import edu.colorado.phet.lwjglphet.utils.ColorPropertyControl;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.platetectonics.PlateTectonicsConstants;
import edu.colorado.phet.platetectonics.dev.PerformanceFrame;
import edu.colorado.phet.platetectonics.tabs.CrustTab;
import edu.colorado.phet.platetectonics.tabs.PlateMotionTab;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class PlateTectonicsApplication
extends LWJGLPhetApplication {
    public static final Property<Boolean> showFPSMeter = new Property<Boolean>(false);
    public static final Property<Boolean> showDebuggingItems = new Property<Boolean>(false);
    public static final Property<Boolean> moveTimeControl = new Property<Boolean>(false);

    public PlateTectonicsApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar();
    }

    private void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        final LWJGLCanvas lWJGLCanvas = LWJGLCanvas.getCanvasInstance(phetFrame);
        this.addModule(new PhetTabbedPane.TabbedModule(lWJGLCanvas){
            {
                super(component);
                this.addTab(new CrustTab(lWJGLCanvas));
                this.addTab(new PlateMotionTab(lWJGLCanvas));
            }
        });
    }

    private void initMenubar() {
        final PhetFrame phetFrame = this.getPhetFrame();
        OptionsMenu optionsMenu = new OptionsMenu();
        if (optionsMenu.getMenuComponentCount() > 0) {
            phetFrame.addMenu(optionsMenu);
        }
        JMenu jMenu = phetFrame.getDeveloperMenu();
        jMenu.add(new JCheckBoxMenuItem("Show Frames Per Second"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        final boolean bl = this.isSelected();
                        LWJGLUtils.invoke(new Runnable(){

                            public void run() {
                                showFPSMeter.set(bl);
                            }
                        });
                    }
                });
            }
        });
        jMenu.add(new JCheckBoxMenuItem("Show Debugging Items"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        final boolean bl = this.isSelected();
                        LWJGLUtils.invoke(new Runnable(){

                            public void run() {
                                showDebuggingItems.set(bl);
                            }
                        });
                    }
                });
            }
        });
        jMenu.add(new JCheckBoxMenuItem("Re-align time control"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.setSelected(moveTimeControl.get());
                        final boolean bl = this.isSelected();
                        LWJGLUtils.invoke(new Runnable(){

                            public void run() {
                                moveTimeControl.set(bl);
                            }
                        });
                    }
                });
            }
        });
        jMenu.add(new JSeparator());
        jMenu.add(new JMenuItem("Performance Options"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new PerformanceFrame();
                    }
                });
            }
        });
        jMenu.add(new JMenuItem("Color Options"){
            {
                super(string);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new JDialog(phetFrame){
                            {
                                this.setTitle("Color Options");
                                this.setResizable(false);
                                this.setContentPane(new JPanel(){
                                    {
                                        this.setLayout(new BoxLayout(this, 1));
                                        this.add(new ColorPropertyControl((Frame)phetFrame, "Dial color: ", PlateTectonicsConstants.DIAL_HIGHLIGHT_COLOR));
                                    }
                                });
                                this.pack();
                                SwingUtils.centerInParent(this);
                            }
                        }.setVisible(true);
                    }
                });
            }
        });
        jMenu.add(new JMenuItem("Show Error Dialog"){
            {
                super(string);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        LWJGLUtils.showErrorDialog(phetFrame, new RuntimeException("This is a test"));
                    }
                });
            }
        });
        jMenu.add(new JMenuItem("Show Mac Java 1.7 Dialog"){
            {
                super(string);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        LWJGLUtils.showMacJava7Warning(phetFrame);
                    }
                });
            }
        });
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        try {
            StartupUtils.setupLibraries();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        new PhetApplicationLauncher().launchSim(stringArray, "plate-tectonics", PlateTectonicsApplication.class);
    }
}

