/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.utils;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class GLSwingForwardingClock
implements IClock {
    private final IClock clock;
    private final Map<ClockListener, ClockListener> swingToGLListenerMap = new HashMap<ClockListener, ClockListener>();

    public GLSwingForwardingClock(IClock iClock) {
        this.clock = iClock;
    }

    public void start() {
        this.clock.start();
    }

    public void pause() {
        this.clock.pause();
    }

    public boolean isPaused() {
        return this.clock.isPaused();
    }

    public boolean isRunning() {
        return this.clock.isRunning();
    }

    public void addClockListener(final ClockListener clockListener) {
        ClockListener clockListener2 = new ClockListener(){

            public void clockTicked(final ClockEvent clockEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        clockListener.clockTicked(clockEvent);
                    }
                });
            }

            public void clockStarted(final ClockEvent clockEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        clockListener.clockStarted(clockEvent);
                    }
                });
            }

            public void clockPaused(final ClockEvent clockEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        clockListener.clockPaused(clockEvent);
                    }
                });
            }

            public void simulationTimeChanged(final ClockEvent clockEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        clockListener.simulationTimeChanged(clockEvent);
                    }
                });
            }

            public void simulationTimeReset(final ClockEvent clockEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        clockListener.simulationTimeReset(clockEvent);
                    }
                });
            }
        };
        this.swingToGLListenerMap.put(clockListener, clockListener2);
        this.clock.addClockListener(clockListener2);
    }

    public void resetSimulationTime() {
        this.clock.resetSimulationTime();
    }

    public double getSimulationTimeChange() {
        return this.clock.getSimulationTimeChange();
    }

    public double getSimulationTime() {
        return this.clock.getSimulationTime();
    }

    public void stepClockWhilePaused() {
        this.clock.stepClockWhilePaused();
    }

    public void stepClockBackWhilePaused() {
        this.clock.stepClockBackWhilePaused();
    }
}

