/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.math;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;

public class Arrow2F {
    private Vector2F tailLocation;
    private Vector2F tipLocation;
    private float headHeight;
    private float headWidth;
    private float tailWidth;
    private float fractionalHeadHeight;
    private boolean scaleTailToo;
    private float headScale;
    private Vector2F direction;
    private Vector2F norm;
    boolean isHeadDynamic = false;
    private Vector2F rightFlap;
    private Vector2F leftFlap;
    private Vector2F rightPin;
    private Vector2F leftPin;
    private Vector2F rightTail;
    private Vector2F leftTail;

    public Arrow2F(Vector2F vector2F, Vector2F vector2F2, float f, float f2, float f3) {
        this.init(vector2F, vector2F2, f, f2, f3);
        this.computeArrow();
    }

    void init(Vector2F vector2F, Vector2F vector2F2, float f, float f2, float f3) {
        this.tailLocation = vector2F;
        this.tipLocation = vector2F2;
        this.headHeight = f;
        this.headWidth = f2;
        this.tailWidth = f3;
    }

    private void computeArrow() {
        if (this.tailLocation.distance(this.tipLocation) != 0.0f) {
            Vector2F vector2F = this.tipLocation.minus(this.tailLocation);
            this.direction = vector2F.normalized();
            float f = this.tipLocation.distance(this.tailLocation);
            float f2 = this.headHeight;
            float f3 = this.headWidth;
            float f4 = this.tailWidth;
            if (this.isHeadDynamic) {
                if (f < this.headHeight / this.fractionalHeadHeight) {
                    f2 = f * this.fractionalHeadHeight;
                    if (this.scaleTailToo) {
                        f4 = this.tailWidth * f2 / this.headHeight;
                        f3 = this.headWidth * f2 / this.headHeight;
                    }
                }
            } else if (f < this.headHeight) {
                throw new RuntimeException("headHeight is bigger than arrow length: length=" + f + " headHeight=" + this.headHeight);
            }
            this.headScale = f2 / this.headHeight;
            this.norm = this.direction.getPerpendicularVector();
            this.rightFlap = this.getPoint(-1.0f * f2, -f3 / 2.0f);
            this.leftFlap = this.getPoint(-1.0f * f2, f3 / 2.0f);
            this.rightPin = this.getPoint(-1.0f * f2, -f4 / 2.0f);
            this.leftPin = this.getPoint(-1.0f * f2, f4 / 2.0f);
            this.rightTail = this.getPoint(-1.0f * f, -f4 / 2.0f);
            this.leftTail = this.getPoint(-1.0f * f, f4 / 2.0f);
        }
    }

    private Vector2F getPoint(float f, float f2) {
        float f3 = this.direction.getX() * f + this.norm.getX() * f2 + this.tipLocation.getX();
        float f4 = this.direction.getY() * f + this.norm.getY() * f2 + this.tipLocation.getY();
        return new Vector2F(f3, f4);
    }

    public Vector2F getTipLocation() {
        return this.tipLocation;
    }

    public Vector2F getLeftFlap() {
        return this.leftFlap;
    }

    public Vector2F getLeftPin() {
        return this.leftPin;
    }

    public Vector2F getLeftTail() {
        return this.leftTail;
    }

    public Vector2F getRightFlap() {
        return this.rightFlap;
    }

    public Vector2F getRightPin() {
        return this.rightPin;
    }

    public Vector2F getRightTail() {
        return this.rightTail;
    }
}

