/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;

public abstract class TextureImage {
    private BufferedImage paintableImage;
    private ByteBuffer buffer;
    private final AffineTransform imageTransform;
    private final int width;
    private final int height;
    private int textureId;
    private boolean textureInitialized = false;
    private int magFilter;
    private int minFilter;

    public TextureImage(int n, int n2, boolean bl, int n3, int n4, AffineTransform affineTransform) {
        this.magFilter = n3;
        this.minFilter = n4;
        assert (LWJGLUtils.isPowerOf2(n));
        assert (LWJGLUtils.isPowerOf2(n2));
        this.width = n;
        this.height = n2;
        this.buffer = ByteBuffer.allocateDirect(4 * n * n2);
        this.imageTransform = affineTransform;
        this.paintableImage = new BufferedImage(n, n2, bl ? 6 : 5);
    }

    public void refreshImage() {
        Graphics2D graphics2D = this.paintableImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.scale(this.imageTransform.getScaleX(), this.imageTransform.getScaleY());
        this.paint(graphics2D);
        graphics2D.dispose();
        final byte[] byArray = (byte[])this.paintableImage.getRaster().getDataElements(0, 0, this.paintableImage.getWidth(), this.paintableImage.getHeight(), null);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TextureImage textureImage = TextureImage.this;
                synchronized (textureImage) {
                    TextureImage.this.buffer.clear();
                    TextureImage.this.buffer.put(byArray, 0, byArray.length);
                    TextureImage.this.buffer.rewind();
                    if (!TextureImage.this.textureInitialized) {
                        TextureImage.this.textureId = GL11.glGenTextures();
                        TextureImage.this.textureInitialized = true;
                    }
                    GL11.glBindTexture(3553, TextureImage.this.textureId);
                    GL11.glTexEnvf(8960, 8704, 8448.0f);
                    GL11.glTexParameterf(3553, 10242, 10496.0f);
                    GL11.glTexParameterf(3553, 10243, 10496.0f);
                    GL11.glTexParameterf(3553, 10240, TextureImage.this.magFilter);
                    GL11.glTexParameterf(3553, 10241, TextureImage.this.minFilter);
                    GL11.glTexImage2D(3553, 0, 4, TextureImage.this.width, TextureImage.this.height, 0, 6408, 5121, TextureImage.this.buffer);
                }
            }
        };
        if (LWJGLUtils.isLWJGLRendererThread()) {
            runnable.run();
        } else {
            LWJGLCanvas.addTask(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useTexture() {
        TextureImage textureImage = this;
        synchronized (textureImage) {
            if (this.textureInitialized) {
                GL11.glBindTexture(3553, this.textureId);
                GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public abstract void paint(Graphics2D var1);

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public AffineTransform getImageTransform() {
        return this.imageTransform;
    }

    public void dispose() {
        if (this.textureInitialized) {
            this.textureInitialized = false;
            GL11.glDeleteTextures(this.textureId);
        }
    }

    public Vector2F localToComponentCoordinates(Vector2F vector2F) {
        Point2D point2D;
        try {
            point2D = this.getImageTransform().inverseTransform(new Point2D.Float(vector2F.x, vector2F.y), new Point2D.Float());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new RuntimeException(noninvertibleTransformException);
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        return new Vector2F(d, d2);
    }
}

