/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.layout;

import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.piccolophet.nodes.layout.Box;
import edu.colorado.phet.common.piccolophet.nodes.layout.PositionStrategy;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Point2D;

public class VBox
extends Box {
    public static final HorizontalPositionStrategy CENTER_ALIGNED = new CenterAligned();
    public static final HorizontalPositionStrategy LEFT_ALIGNED = new LeftAligned();
    public static final HorizontalPositionStrategy RIGHT_ALIGNED = new RightAligned();
    private static final HorizontalPositionStrategy DEFAULT_POSITION_STRATEGY = CENTER_ALIGNED;

    public VBox(HorizontalPositionStrategy horizontalPositionStrategy, PNode ... pNodeArray) {
        this(10.0, horizontalPositionStrategy, pNodeArray);
    }

    public VBox(double d, HorizontalPositionStrategy horizontalPositionStrategy, PNode ... pNodeArray) {
        super(d, new Function1<PBounds, Double>(){

            @Override
            public Double apply(PBounds pBounds) {
                return pBounds.getWidth();
            }
        }, new Function1<PBounds, Double>(){

            @Override
            public Double apply(PBounds pBounds) {
                return pBounds.getHeight();
            }
        }, horizontalPositionStrategy, pNodeArray);
    }

    private static class CenterAligned
    implements HorizontalPositionStrategy {
        private CenterAligned() {
        }

        public Point2D getRelativePosition(PNode pNode, double d, double d2) {
            return new Point2D.Double(d / 2.0 - pNode.getFullBounds().getWidth() / 2.0, d2);
        }
    }

    public static interface HorizontalPositionStrategy
    extends PositionStrategy {
    }

    private static class LeftAligned
    implements HorizontalPositionStrategy {
        private LeftAligned() {
        }

        public Point2D getRelativePosition(PNode pNode, double d, double d2) {
            return new Point2D.Double(0.0, d2);
        }
    }

    private static class RightAligned
    implements HorizontalPositionStrategy {
        private RightAligned() {
        }

        public Point2D getRelativePosition(PNode pNode, double d, double d2) {
            return new Point2D.Double(d - pNode.getFullBounds().getWidth(), d2);
        }
    }
}

