/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.layout;

import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.piccolophet.nodes.layout.Box;
import edu.colorado.phet.common.piccolophet.nodes.layout.PositionStrategy;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Point2D;

public class HBox
extends Box {
    public static final VerticalPositionStrategy CENTER_ALIGNED = new CenterAligned();
    public static final VerticalPositionStrategy TOP_ALIGNED = new TopAligned();
    public static final VerticalPositionStrategy BOTTOM_ALIGNED = new BottomAligned();
    private static final VerticalPositionStrategy DEFAULT_POSITION_STRATEGY = CENTER_ALIGNED;

    public HBox(double d, VerticalPositionStrategy verticalPositionStrategy, PNode ... pNodeArray) {
        super(d, new Function1<PBounds, Double>(){

            @Override
            public Double apply(PBounds pBounds) {
                return pBounds.getHeight();
            }
        }, new Function1<PBounds, Double>(){

            @Override
            public Double apply(PBounds pBounds) {
                return pBounds.getWidth();
            }
        }, verticalPositionStrategy, pNodeArray);
    }

    private static class BottomAligned
    implements VerticalPositionStrategy {
        private BottomAligned() {
        }

        public Point2D getRelativePosition(PNode pNode, double d, double d2) {
            return new Point2D.Double(d2, d - pNode.getFullBounds().getHeight());
        }
    }

    private static class CenterAligned
    implements VerticalPositionStrategy {
        private CenterAligned() {
        }

        public Point2D getRelativePosition(PNode pNode, double d, double d2) {
            return new Point2D.Double(d2, d / 2.0 - pNode.getFullBounds().getHeight() / 2.0);
        }
    }

    private static class TopAligned
    implements VerticalPositionStrategy {
        private TopAligned() {
        }

        public Point2D getRelativePosition(PNode pNode, double d, double d2) {
            return new Point2D.Double(d2, 0.0);
        }
    }

    public static interface VerticalPositionStrategy
    extends PositionStrategy {
    }
}

