/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeedometerNode
extends PNode {
    public final PNode underTicksLayer = new PNode();
    private final double maxSpeed;
    private final double anglePerTick = 0.19634954084936207;
    private final int numTicks = 20;

    public SpeedometerNode(String string, final double d, final ObservableProperty<Option<Double>> observableProperty, double d2) {
        this.maxSpeed = d2;
        this.addChild(new PhetPPath(new Ellipse2D.Double(0.0, 0.0, d, d), Color.white, new BasicStroke(2.0f), Color.gray));
        this.addChild(this.underTicksLayer);
        this.addChild(new PhetPText(string){
            {
                super(string);
                this.setFont(new PhetFont(16));
                if (this.getFullWidth() > 65.0) {
                    this.scale(65.0 / this.getFullWidth());
                }
                this.setOffset(d / 2.0 - this.getFullBounds().getWidth() / 2.0, d * 0.2);
            }
        });
        this.addChild(new PhetPPath(new BasicStroke(2.0f), Color.red){
            {
                super(stroke, paint);
                observableProperty.addObserver(new VoidFunction1<Option<Double>>(){

                    @Override
                    public void apply(Option<Double> option) {
                        if (option.isSome()) {
                            double d = SpeedometerNode.this.speedToAngle(option.get());
                            Vector2D vector2D = new Vector2D(d / 2.0, d / 2.0);
                            Vector2D vector2D2 = Vector2D.createPolar(1.0, d);
                            Vector2D vector2D3 = vector2D.minus(vector2D2.times(d / 10.0));
                            Vector2D vector2D4 = vector2D.plus(vector2D2.times(d / 2.0));
                            if (Double.isNaN(d) || Double.isInfinite(d)) {
                                this.setPathTo(new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0));
                            } else {
                                this.setPathTo(new Line2D.Double(vector2D3.toPoint2D(), vector2D4.toPoint2D()));
                            }
                        } else {
                            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0));
                        }
                    }
                });
            }
        });
        double d3 = 2.0;
        this.addChild(new PhetPPath((Shape)new Ellipse2D.Double(d / 2.0 - d3 / 2.0, d / 2.0 - d3 / 2.0, d3, d3), (Paint)Color.blue));
        double d4 = d2 / 20.0;
        for (int i = 0; i < 21; ++i) {
            double d5 = this.speedToAngle((double)i * d4);
            Vector2D vector2D = new Vector2D(d / 2.0, d / 2.0);
            Vector2D vector2D2 = Vector2D.createPolar(1.0, d5);
            Vector2D vector2D3 = vector2D.plus(vector2D2.times(d / 2.0 * (i % 2 == 0 ? 0.9 : 0.93)));
            Vector2D vector2D4 = vector2D.plus(vector2D2.times(d / 2.0));
            PhetPPath phetPPath = new PhetPPath(new Line2D.Double(vector2D3.toPoint2D(), vector2D4.toPoint2D()), (Stroke)new BasicStroke(i % 2 == 0 ? 1.0f : 0.5f), (Paint)Color.black);
            this.addChild(phetPPath);
        }
    }

    public double speedToAngle(double d) {
        Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, this.maxSpeed, -3.5342917352885173, 0.39269908169872414);
        return linearFunction.evaluate(d);
    }
}

