/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import edu.colorado.phet.common.phetcommon.util.function.Function1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalUtils {
    public static <T> List<T> flatten(Collection<? extends Collection<? extends T>> collection) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Collection<T> collection2 : collection) {
            arrayList.addAll(collection2);
        }
        return arrayList;
    }

    public static <T> String mkString(Collection<T> collection, Function1<? super T, String> function1, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (T t : collection) {
            if (!bl) {
                stringBuilder.append(string);
            }
            bl = false;
            stringBuilder.append(function1.apply(t));
        }
        return stringBuilder.toString();
    }

    public static <T> String mkString(Collection<T> collection, String string) {
        return FunctionalUtils.mkString(collection, new Function1<T, String>(){

            @Override
            public String apply(T t) {
                return t.toString();
            }
        }, string);
    }

    public static <T, U> List<U> map(Collection<T> collection, Function1<? super T, ? extends U> function1) {
        ArrayList<U> arrayList = new ArrayList<U>();
        for (T t : collection) {
            arrayList.add(function1.apply(t));
        }
        return arrayList;
    }

    public static <T> List<T> unique(Collection<T> collection) {
        HashSet<T> hashSet = new HashSet<T>();
        for (T t : collection) {
            hashSet.add(t);
        }
        return new ArrayList(hashSet);
    }

    public static void repeat(Runnable runnable, int n) {
        for (int i = 0; i < n; ++i) {
            runnable.run();
        }
    }

    public static List<Integer> rangeInclusive(int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2 - n + 1);
        for (int i = n; i <= n2; ++i) {
            arrayList.add(i);
        }
        return arrayList;
    }
}

