/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math.vector;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import java.io.Serializable;

public abstract class AbstractVector3F
implements Serializable {
    public abstract float getX();

    public abstract float getY();

    public abstract float getZ();

    public float magnitude() {
        return (float)Math.sqrt(this.magnitudeSquared());
    }

    public float magnitudeSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    public float dot(AbstractVector3F abstractVector3F) {
        return this.getX() * abstractVector3F.getX() + this.getY() * abstractVector3F.getY() + this.getZ() * abstractVector3F.getZ();
    }

    public Vector3F cross(AbstractVector3F abstractVector3F) {
        return new Vector3F(this.getY() * abstractVector3F.getZ() - this.getZ() * abstractVector3F.getY(), this.getZ() * abstractVector3F.getX() - this.getX() * abstractVector3F.getZ(), this.getX() * abstractVector3F.getY() - this.getY() * abstractVector3F.getX());
    }

    public float angleBetween(AbstractVector3F abstractVector3F) {
        return (float)Math.acos(MathUtil.clamp(-1.0, this.normalized().dot(abstractVector3F.normalized()), 1.0));
    }

    public Vector3F normalized() {
        float f = this.magnitude();
        if (f == 0.0f) {
            throw new UnsupportedOperationException("Cannot normalize a zero-magnitude vector.");
        }
        return new Vector3F(this.getX() / f, this.getY() / f, this.getZ() / f);
    }

    public Vector3F times(float f) {
        return new Vector3F(this.getX() * f, this.getY() * f, this.getZ() * f);
    }

    public Vector3F componentTimes(AbstractVector3F abstractVector3F) {
        return new Vector3F(this.getX() * abstractVector3F.getX(), this.getY() * abstractVector3F.getY(), this.getZ() * abstractVector3F.getZ());
    }

    public Vector3F plus(AbstractVector3F abstractVector3F) {
        return new Vector3F(this.getX() + abstractVector3F.getX(), this.getY() + abstractVector3F.getY(), this.getZ() + abstractVector3F.getZ());
    }

    public Vector3F minus(AbstractVector3F abstractVector3F) {
        return new Vector3F(this.getX() - abstractVector3F.getX(), this.getY() - abstractVector3F.getY(), this.getZ() - abstractVector3F.getZ());
    }

    public Vector3F negated() {
        return new Vector3F(-this.getX(), -this.getY(), -this.getZ());
    }
}

