/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math.vector;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import java.io.Serializable;

public abstract class AbstractVector2F
implements Serializable {
    public abstract float getX();

    public abstract float getY();

    public float magnitude() {
        return (float)Math.sqrt(this.magnitudeSquared());
    }

    public float magnitudeSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    public float getAngle() {
        return (float)Math.atan2(this.getY(), this.getX());
    }

    public float distance(AbstractVector2F abstractVector2F) {
        float f = this.getX() - abstractVector2F.getX();
        float f2 = this.getY() - abstractVector2F.getY();
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public Vector2F normalized() {
        float f = this.magnitude();
        if (f == 0.0f) {
            throw new UnsupportedOperationException("Cannot normalize a zero-magnitude vector.");
        }
        return new Vector2F(this.getX() / f, this.getY() / f);
    }

    public Vector2F times(float f) {
        return new Vector2F(this.getX() * f, this.getY() * f);
    }

    public Vector2F plus(AbstractVector2F abstractVector2F) {
        return this.plus(abstractVector2F.getX(), abstractVector2F.getY());
    }

    public Vector2F plus(float f, float f2) {
        return new Vector2F(this.getX() + f, this.getY() + f2);
    }

    public Vector2F getPerpendicularVector() {
        return new Vector2F(this.getY(), -this.getX());
    }

    public Vector2F minus(float f, float f2) {
        return new Vector2F(this.getX() - f, this.getY() - f2);
    }

    public Vector2F minus(AbstractVector2F abstractVector2F) {
        return this.minus(abstractVector2F.getX(), abstractVector2F.getY());
    }

    public Vector2F getRotatedInstance(float f) {
        return Vector2F.createPolar(this.magnitude(), this.getAngle() + f);
    }
}

