/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

public class Complex {
    public static final Complex ZERO = new Complex(0.0, 0.0);
    public static final Complex I = new Complex(0.0, 1.0);
    protected double _real;
    protected double _imaginary;

    public Complex(double d, double d2) {
        this._real = d;
        this._imaginary = d2;
    }

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(Complex complex) {
        this(complex._real, complex._imaginary);
    }

    public Complex getAdd(Complex complex) {
        return this.getAdd(complex._real, complex._imaginary);
    }

    public Complex getAdd(double d, double d2) {
        return new Complex(this._real + d, this._imaginary + d2);
    }

    public Complex getSubtract(Complex complex) {
        return this.getSubtract(complex._real, complex._imaginary);
    }

    public Complex getSubtract(double d, double d2) {
        return new Complex(this._real - d, this._imaginary - d2);
    }

    public Complex getMultiply(Complex complex) {
        return this.getMultiply(complex._real, complex._imaginary);
    }

    public Complex getMultiply(double d, double d2) {
        return new Complex(this._real * d - this._imaginary * d2, this._real * d2 + this._imaginary * d);
    }

    public Complex getMultiply(double d) {
        return this.getMultiply(d, 0.0);
    }

    public Complex getDivide(Complex complex) {
        return this.getDivide(complex._real, complex._imaginary);
    }

    public Complex getDivide(double d, double d2) {
        double d3 = d * d + d2 * d2;
        double d4 = this._real * d + this._imaginary * d2;
        double d5 = this._imaginary * d - this._real * d2;
        return new Complex(d4 / d3, d5 / d3);
    }

    public double getAbs() {
        return Math.sqrt(this._real * this._real + this._imaginary * this._imaginary);
    }

    public Complex getCanonicalSquareRoot() {
        double d = this.getAbs();
        return new Complex(Math.sqrt((d + this._real) / 2.0), Math.sqrt((d - this._real) / 2.0));
    }

    public Complex getOpposite() {
        return new Complex(-this._real, -this._imaginary);
    }

    public static Complex getExp(Complex complex) {
        return Complex.getExp(complex._real, complex._imaginary);
    }

    public static Complex getExp(double d, double d2) {
        double d3 = Math.exp(d);
        return new Complex(d3 * Math.cos(d2), d3 * Math.sin(d2));
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            bl = this._real == complex._real && this._imaginary == complex._imaginary;
        }
        return bl;
    }

    public String toString() {
        return "[" + this._real + "+" + this._imaginary + "i]";
    }
}

