/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.controller.module.BaseLaserModule;
import edu.colorado.phet.lasers.view.PhotonGraphic;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class PumpBeamViewPanel
extends JPanel {
    private ButtonGroup pumpPhotonBG;
    private JRadioButton pumpPhotonViewRB;
    private JRadioButton pumpCurtainViewRB;
    private BaseLaserModule module;

    public PumpBeamViewPanel(BaseLaserModule baseLaserModule) {
        super(new GridBagLayout());
        this.module = baseLaserModule;
        PumpBeamViewPanel pumpBeamViewPanel = this;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LasersResources.getString("WaveViewControlPanel.pumpPanelTitle"));
        pumpBeamViewPanel.setBorder(titledBorder);
        this.pumpPhotonBG = new ButtonGroup();
        this.pumpPhotonViewRB = new JRadioButton(LasersResources.getString("WaveViewControlPanel.photonView"));
        this.pumpCurtainViewRB = new JRadioButton(LasersResources.getString("WaveViewControlPanel.curtainView"));
        this.pumpPhotonBG.add(this.pumpPhotonViewRB);
        this.pumpPhotonBG.add(this.pumpCurtainViewRB);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        pumpBeamViewPanel.add((Component)this.pumpPhotonViewRB, gridBagConstraints);
        pumpBeamViewPanel.add((Component)this.pumpCurtainViewRB, gridBagConstraints);
        this.pumpPhotonViewRB.addActionListener(new PumpPhotonRBListener());
        this.pumpCurtainViewRB.addActionListener(new PumpPhotonRBListener());
        this.pumpCurtainViewRB.setSelected(true);
    }

    public void setUpperTransitionView(int n) {
        this.pumpPhotonViewRB.setSelected(n == 0);
        this.pumpCurtainViewRB.setSelected(n == 2);
    }

    private class PumpPhotonRBListener
    implements ActionListener {
        private PumpPhotonRBListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = SwingUtils.getSelection(PumpBeamViewPanel.this.pumpPhotonBG);
            if (jRadioButton == PumpBeamViewPanel.this.pumpPhotonViewRB) {
                PhotonGraphic.setAllVisible(true, PumpBeamViewPanel.this.module.getPumpingBeam().getWavelength());
                PumpBeamViewPanel.this.module.setPumpingPhotonView(0);
            }
            if (jRadioButton == PumpBeamViewPanel.this.pumpCurtainViewRB) {
                PhotonGraphic.setAllVisible(false, PumpBeamViewPanel.this.module.getPumpingBeam().getWavelength());
                PumpBeamViewPanel.this.module.setPumpingPhotonView(2);
            }
        }
    }
}

