/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.quantum.model;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.dischargelamps.quantum.model.Electron;
import edu.colorado.phet.dischargelamps.quantum.model.ElectronSource;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;

public class ElectronSink
implements ModelElement,
ElectronSource.ElectronProductionListener {
    private BaseModel model;
    private Line2D.Double line;
    private List electrons = new ArrayList();
    private ArrayList removeList = new ArrayList();
    private EventChannel listenerChannel = new EventChannel(ElectronAbsorptionListener.class);
    private ElectronAbsorptionListener electronAbsorptionListenerProxy = (ElectronAbsorptionListener)this.listenerChannel.getListenerProxy();

    public ElectronSink(BaseModel baseModel, Point2D point2D, Point2D point2D2) {
        this.model = baseModel;
        this.line = new Line2D.Double(point2D, point2D2);
    }

    public void stepInTime(double d) {
        for (int i = 0; i < this.electrons.size(); ++i) {
            Electron electron = (Electron)this.electrons.get(i);
            if (!this.line.intersectsLine(electron.getPosition().getX(), electron.getPosition().getY(), electron.getPositionPrev().getX(), electron.getPositionPrev().getY())) continue;
            this.model.removeModelElement(electron);
            this.electronAbsorptionListenerProxy.electronAbsorbed(new ElectronAbsorptionEvent(this, electron));
            this.removeList.add(electron);
        }
        for (Electron electron : this.removeList) {
            electron.leaveSystem();
        }
        this.electrons.removeAll(this.removeList);
        this.removeList.clear();
    }

    public void addListener(ElectronAbsorptionListener electronAbsorptionListener) {
        this.listenerChannel.addListener(electronAbsorptionListener);
    }

    public void electronProduced(ElectronSource.ElectronProductionEvent electronProductionEvent) {
        Electron electron = electronProductionEvent.getElectron();
        this.electrons.add(electron);
        electron.addChangeListener(new ElectronRemover());
    }

    public class ElectronAbsorptionEvent
    extends EventObject {
        private Electron electron;

        public ElectronAbsorptionEvent(Object object, Electron electron) {
            super(object);
            this.electron = electron;
        }
    }

    public static interface ElectronAbsorptionListener
    extends EventListener {
        public void electronAbsorbed(ElectronAbsorptionEvent var1);
    }

    private class ElectronRemover
    extends Electron.ChangeListenerAdapter {
        private ElectronRemover() {
        }

        public void leftSystem(Electron.ChangeEvent changeEvent) {
            ElectronSink.this.electrons.remove(changeEvent.getElectron());
        }
    }
}

