/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.quantum.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.common.quantum.model.QuantumModel;
import java.awt.geom.Point2D;
import java.util.Random;

class StateLifetimeManager
implements ModelElement {
    private Atom atom;
    private boolean emitOnStateChange;
    private double lifeTime;
    private double deathTime;
    private AtomicState state;
    private QuantumModel model;
    private EmissionDirectionStrategy emissionDirectionStrategy = new SometimesHorizontalButMostlyRandomEmissionDirectionStrategy(0.1);

    public StateLifetimeManager(Atom atom, boolean bl, QuantumModel quantumModel) {
        this.atom = atom;
        this.emitOnStateChange = bl;
        this.model = quantumModel;
        quantumModel.addModelElement(this);
        double d = 0.0;
        while (d == 0.0) {
            d = Math.random();
        }
        this.state = atom.getCurrState();
        this.deathTime = atom.isStateLifetimeFixed() ? this.state.getMeanLifeTime() : Math.pow(-Math.log(d), 0.5) * this.state.getMeanLifeTime();
        this.lifeTime = 0.0;
    }

    public void stepInTime(double d) {
        this.lifeTime += d;
        if (this.lifeTime >= this.deathTime) {
            AtomicState atomicState = this.atom.getEnergyStateAfterEmission();
            if (this.emitOnStateChange) {
                double d2 = Photon.DEFAULT_SPEED * this.model.getPhotonSpeedScale();
                double d3 = this.emissionDirectionStrategy.getEmissionDirection();
                double d4 = d2 * Math.cos(d3);
                double d5 = d2 * Math.sin(d3);
                if (atomicState != this.atom.getCurrState()) {
                    Photon photon = new Photon(this.state.determineEmittedPhotonWavelength(atomicState), new Point2D.Double(this.atom.getPosition().getX(), this.atom.getPosition().getY()), new MutableVector2D(d4, d5));
                    MutableVector2D mutableVector2D = new MutableVector2D(photon.getVelocity()).normalize();
                    MutableVector2D mutableVector2D2 = new MutableVector2D(this.atom.getPosition());
                    mutableVector2D2.add(mutableVector2D.scale(this.atom.getRadius() + 10.0));
                    photon.setPosition(mutableVector2D2.getX(), mutableVector2D2.getY());
                    this.atom.emitPhoton(photon);
                }
            }
            this.atom.setCurrState(atomicState);
            this.kill();
        }
    }

    public void kill() {
        this.model.removeModelElement(this);
    }

    public static interface EmissionDirectionStrategy {
        public double getEmissionDirection();
    }

    public static class RandomEmissionDirectionStrategy
    implements EmissionDirectionStrategy {
        private static Random random = new Random(System.currentTimeMillis());

        public double getEmissionDirection() {
            return random.nextDouble() * Math.PI * 2.0;
        }
    }

    public static class SometimesHorizontalButMostlyRandomEmissionDirectionStrategy
    extends RandomEmissionDirectionStrategy {
        private static Random random = new Random(System.currentTimeMillis());
        private double horizontalLikelihood = 0.4;

        public SometimesHorizontalButMostlyRandomEmissionDirectionStrategy(double d) {
            this.horizontalLikelihood = d;
        }

        public double getEmissionDirection() {
            if (random.nextDouble() <= this.horizontalLikelihood) {
                return Math.PI * (double)(random.nextBoolean() ? 1 : 0);
            }
            return super.getEmissionDirection();
        }
    }
}

