/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.photon;

import edu.colorado.phet.common.piccolophet.nodes.photon.PhotonNode;
import java.awt.Image;
import java.util.HashMap;

public class PhotonImageCache {
    private static final Integer UV_IMAGE_KEY = new Integer(379);
    private static final Integer IR_IMAGE_KEY = new Integer(781);
    private static final ImageCache IMAGE_CACHE = new ImageCache();

    public Image getImage(double d, double d2) {
        Image image = IMAGE_CACHE.get(d, d2);
        if (image == null) {
            image = this.createImage(d, d2);
            IMAGE_CACHE.put(d, d2, image);
        }
        return image;
    }

    protected Image createImage(double d, double d2) {
        return PhotonNode.createImage(d, d2);
    }

    private static class ImageCache {
        private HashMap _diameterMap = new HashMap();

        public void put(double d, double d2, Image image) {
            Object object = this.diameterToKey(d2);
            HashMap<Object, Image> hashMap = (HashMap<Object, Image>)this._diameterMap.get(object);
            if (hashMap == null) {
                hashMap = new HashMap<Object, Image>();
                this._diameterMap.put(object, hashMap);
            }
            Object object2 = this.wavelengthToKey(d);
            hashMap.put(object2, image);
        }

        public Image get(double d, double d2) {
            Image image = null;
            Object object = this.diameterToKey(d2);
            HashMap hashMap = (HashMap)this._diameterMap.get(object);
            if (hashMap != null) {
                Object object2 = this.wavelengthToKey(d);
                image = (Image)hashMap.get(object2);
            }
            return image;
        }

        private Object diameterToKey(double d) {
            return new Double(d);
        }

        private Object wavelengthToKey(double d) {
            Integer n = d < 380.0 ? UV_IMAGE_KEY : (d > 780.0 ? IR_IMAGE_KEY : new Integer((int)d));
            return n;
        }
    }
}

