/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.controls;

import edu.colorado.phet.common.controls.SpectrumGraphic;
import edu.colorado.phet.common.controls.SpectrumSliderKnob;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class SpectrumSliderWithSquareCursor
extends CompositePhetGraphic {
    private static final Dimension DEFAULT_KNOB_SIZE = new Dimension(20, 30);
    private static final double HORIZONTAL_ROTATION_ANGLE = Math.toRadians(0.0);
    private static final double VERTICAL_ROTATION_ANGLE = Math.toRadians(-90.0);
    private static Color KNOB_INVISIBLE_COLOR = new Color(140, 140, 140);
    private Component _component;
    private int _value;
    private int _minimum;
    private int _maximum;
    private double _transmissionWidth;
    private Point _location;
    private int _orientation;
    private Rectangle _dragBounds;
    private int _mouseOffset;
    private EventListenerList _listenerList;
    private PhetGraphic _spectrum;
    private SpectrumSliderKnob _knob;
    private PhetShapeGraphic spectrumCursor;

    public SpectrumSliderWithSquareCursor(Component component, double d, double d2) {
        super(null);
        this._component = component;
        this._value = 0;
        this._minimum = (int)d;
        this._maximum = (int)d2;
        this._orientation = 0;
        this._transmissionWidth = 0.0;
        this._dragBounds = new Rectangle(0, 0, 0, 0);
        this._mouseOffset = 0;
        this._listenerList = new EventListenerList();
        this._spectrum = new SpectrumGraphic(component, d, d2);
        this.addGraphic(this._spectrum);
        this._knob = new SpectrumSliderKnob(component, DEFAULT_KNOB_SIZE, this.getRotationAngle());
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 2.0, this._knob.getLocation().getY());
        this.spectrumCursor = new PhetShapeGraphic(component, double_, new BasicStroke(1.0f), Color.black);
        this.spectrumCursor.setRegistrationPoint(1, 0);
        this.addGraphic(this.spectrumCursor, 1.0E14);
        super.addGraphic(this._knob);
        super.setCursorHand();
        super.addMouseInputListener(new SpectrumSliderMouseInputListener());
        this.setLocation(0, 0);
    }

    protected void setKnob(SpectrumSliderKnob spectrumSliderKnob) {
        this.removeGraphic(this._knob);
        this._knob = spectrumSliderKnob;
        this.addGraphic(this._knob);
        this.setBoundsDirty();
        this.repaint();
    }

    public SpectrumSliderKnob getKnob() {
        return this._knob;
    }

    public void setValue(int n) {
        this._value = MathUtil.clamp(this._minimum, n, this._maximum);
        this.updateKnob();
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public int getValue() {
        return this._value;
    }

    private int getValue(int n, int n2) {
        double d = this._orientation == 0 ? (double)(n - this._dragBounds.x) / (double)this._dragBounds.width : 1.0 - (double)(n2 - this._dragBounds.y) / (double)this._dragBounds.height;
        int n3 = (int)(d * (double)(this._maximum - this._minimum)) + this._minimum;
        return n3;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("invalid orientation: " + n);
        }
        if (n != this._orientation) {
            this._orientation = n;
            this._knob.setAngle(this.getRotationAngle());
            this.updateUI();
        }
    }

    public void setTransmissionWidth(double d) {
        this._transmissionWidth = d;
        this.repaint();
    }

    public void setLocation(Point point) {
        this._location = point;
        this.updateUI();
    }

    public void setLocation(int n, int n2) {
        this.setLocation(new Point(n, n2));
    }

    public Point getLocation() {
        return this._location;
    }

    public void setSpectrumSize(Dimension dimension) {
        BufferedImage bufferedImage;
        String string = "images/spectrum.png";
        try {
            bufferedImage = ImageLoader.loadBufferedImage(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Image resource not found: " + string);
        }
        double d = (double)dimension.width / (double)bufferedImage.getWidth();
        double d2 = (double)dimension.height / (double)bufferedImage.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d, d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        this._spectrum.setTransform(affineTransform);
        this.updateUI();
    }

    public void setKnobSize(Dimension dimension) {
        this._knob.setSize(dimension);
        this.repaint();
    }

    public Rectangle getBounds() {
        Rectangle rectangle = new Rectangle(this._spectrum.getBounds());
        rectangle.add(this._knob.getPhetGraphic().getBounds());
        return rectangle;
    }

    public void setVisible(boolean bl) {
        if (bl != super.isVisible()) {
            super.setVisible(bl);
            this.repaint();
        }
    }

    private double getRotationAngle() {
        double d = this._orientation == 0 ? HORIZONTAL_ROTATION_ANGLE : VERTICAL_ROTATION_ANGLE;
        return d;
    }

    private void updateUI() {
        Rectangle rectangle = this._spectrum.getBounds();
        Rectangle rectangle2 = this._knob.getBounds();
        int n = this._location.x;
        int n2 = this._location.y;
        if (this._orientation == 0) {
            this._spectrum.setLocation(n, n2);
            this._dragBounds = new Rectangle(0, rectangle.height, rectangle.width, 0);
        } else {
            double d = this.getRotationAngle();
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d);
            this._spectrum.setTransform(affineTransform);
            this._spectrum.setLocation(n, n2 + rectangle.height);
            this._dragBounds = new Rectangle(rectangle.width, 0, 0, rectangle.height);
        }
        this.updateKnob();
        this.spectrumCursor.setShape(new Rectangle2D.Double(0.0, 0.0, 2.0, this._spectrum.getHeight()));
    }

    protected void updateKnob() {
        int n;
        int n2;
        double d;
        if (this._orientation == 0) {
            d = (double)(this._value - this._minimum) / (double)(this._maximum - this._minimum);
            n2 = this._dragBounds.x + (int)(d * (double)this._dragBounds.width);
            n = this._dragBounds.y;
        } else {
            d = 1.0 - (double)(this._value - this._minimum) / (double)(this._maximum - this._minimum);
            n2 = (int)this._knob.getLocation().getX();
            n = (int)(d * (double)this._dragBounds.height);
            n2 = this._dragBounds.x;
            n = this._dragBounds.y + (int)(d * (double)this._dragBounds.height);
        }
        this._knob.setLocation(n2 + (int)this.getLocation().getX(), n + (int)this.getLocation().getY());
        Color color = VisibleColor.wavelengthToColor(this._value);
        color = color.equals(VisibleColor.INVISIBLE) ? KNOB_INVISIBLE_COLOR : color;
        this._knob.setPaint(color);
        this.repaint();
    }

    public void repaint() {
        Rectangle rectangle = this.getBounds();
        this._component.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paint(Graphics2D graphics2D) {
        if (super.isVisible()) {
            this.spectrumCursor.setLocation((int)this._knob.getLocation().getX(), (int)this.getLocation().getY());
            this._spectrum.paint(graphics2D);
            super.paint(graphics2D);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private class SpectrumSliderMouseInputListener
    extends MouseInputAdapter {
        private SpectrumSliderMouseInputListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            int n2;
            if (SpectrumSliderWithSquareCursor.this._orientation == 0) {
                n2 = mouseEvent.getX() - SpectrumSliderWithSquareCursor.this._mouseOffset - (int)SpectrumSliderWithSquareCursor.this.getLocation().getX();
                n = mouseEvent.getY();
            } else {
                n2 = mouseEvent.getX();
                n = mouseEvent.getY() - SpectrumSliderWithSquareCursor.this._mouseOffset - (int)SpectrumSliderWithSquareCursor.this.getLocation().getY();
            }
            int n3 = Math.max(((SpectrumSliderWithSquareCursor)SpectrumSliderWithSquareCursor.this)._dragBounds.x, Math.min(((SpectrumSliderWithSquareCursor)SpectrumSliderWithSquareCursor.this)._dragBounds.x + ((SpectrumSliderWithSquareCursor)SpectrumSliderWithSquareCursor.this)._dragBounds.width, n2));
            int n4 = Math.max(((SpectrumSliderWithSquareCursor)SpectrumSliderWithSquareCursor.this)._dragBounds.y, Math.min(((SpectrumSliderWithSquareCursor)SpectrumSliderWithSquareCursor.this)._dragBounds.y + ((SpectrumSliderWithSquareCursor)SpectrumSliderWithSquareCursor.this)._dragBounds.height, n));
            int n5 = SpectrumSliderWithSquareCursor.this.getValue(n3, n4);
            if (n5 != SpectrumSliderWithSquareCursor.this.getValue()) {
                SpectrumSliderWithSquareCursor.this.setValue(n5);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SpectrumSliderWithSquareCursor.this._orientation == 0) {
                SpectrumSliderWithSquareCursor.this._mouseOffset = mouseEvent.getX() - ((SpectrumSliderWithSquareCursor)SpectrumSliderWithSquareCursor.this)._knob.getLocation().x;
            } else {
                SpectrumSliderWithSquareCursor.this._mouseOffset = mouseEvent.getY() - ((SpectrumSliderWithSquareCursor)SpectrumSliderWithSquareCursor.this)._knob.getLocation().y;
            }
        }
    }
}

