/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phetgraphicsdemo.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.phetgraphicsdemo.PhetGraphicsDemoResources;
import edu.colorado.phet.phetgraphicsdemo.model.WindmillModelElement;
import edu.colorado.phet.phetgraphicsdemo.view.InteractivityHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class WindmillGraphic
extends CompositePhetGraphic {
    public WindmillGraphic(Component component, WindmillModelElement windmillModelElement) {
        super(component);
        BufferedImage bufferedImage = PhetGraphicsDemoResources.getImage("house.png");
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(component, bufferedImage);
        phetImageGraphic.setLocation(-65, -40);
        WindmillBladesGraphic windmillBladesGraphic = new WindmillBladesGraphic(component, windmillModelElement);
        windmillBladesGraphic.setLocation(0, 0);
        this.addGraphic(phetImageGraphic);
        this.addGraphic(windmillBladesGraphic);
        InteractivityHandler.register(this);
    }

    public class WindmillBladeGraphic
    extends PhetShapeGraphic {
        public WindmillBladeGraphic(Component component) {
            super(component);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(-20.0f, -100.0f);
            generalPath.lineTo(20.0f, -100.0f);
            generalPath.closePath();
            this.setShape(generalPath);
            this.setPaint(Color.BLACK);
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.setRenderingHints(renderingHints);
        }
    }

    public class WindmillBladesGraphic
    extends CompositePhetGraphic
    implements SimpleObserver {
        private WindmillModelElement _windmillModelElement;

        public WindmillBladesGraphic(Component component, WindmillModelElement windmillModelElement) {
            super(component);
            this._windmillModelElement = windmillModelElement;
            this._windmillModelElement.addObserver(this);
            int n = this._windmillModelElement.getNumberOfBlades();
            double d = 360.0 / (double)n;
            for (int i = 0; i < n; ++i) {
                WindmillBladeGraphic windmillBladeGraphic = new WindmillBladeGraphic(component);
                windmillBladeGraphic.rotate(Math.toRadians((double)i * d));
                this.addGraphic(windmillBladeGraphic);
            }
        }

        public void finalize() {
            this._windmillModelElement.removeObserver(this);
        }

        public void update() {
            this.clearTransform();
            this.rotate(Math.toRadians(this._windmillModelElement.getRotationAngle()));
        }
    }
}

