/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phetgraphicsdemo.view;

import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationEvent;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class InteractivityHandler
extends MouseInputAdapter
implements TranslationListener {
    private PhetGraphic _graphic;
    private int _previousX;
    private int _previousY;

    public static void register(PhetGraphic phetGraphic) {
        new InteractivityHandler(phetGraphic);
    }

    private InteractivityHandler(PhetGraphic phetGraphic) {
        this._graphic = phetGraphic;
        this._graphic.setCursorHand();
        this._graphic.addTranslationListener(this);
        this._graphic.addMouseInputListener(this);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            int n = 5;
            if (mouseEvent.getX() < this._previousX) {
                n = -n;
            }
            this._graphic.rotate(Math.toRadians(n));
            this._previousX = mouseEvent.getX();
            this._previousY = mouseEvent.getY();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this._previousX = mouseEvent.getX();
        this._previousY = mouseEvent.getY();
    }

    public void translationOccurred(TranslationEvent translationEvent) {
        if (SwingUtilities.isLeftMouseButton(translationEvent.getMouseEvent())) {
            int n = this._graphic.getLocation().x + translationEvent.getDx();
            int n2 = this._graphic.getLocation().y + translationEvent.getDy();
            this._graphic.setLocation(n, n2);
        }
    }
}

