/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phetgraphicsdemo.view;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;

public class DebuggerGraphic
extends PhetGraphic {
    private boolean _boundsEnabled = true;
    private Color _boundsColor = Color.BLUE;
    private BasicStroke _boundsStroke = new BasicStroke(1.0f);
    private boolean _locationEnabled = true;
    private Color _locationColor = Color.RED;
    private BasicStroke _locationStroke = new BasicStroke(2.0f);
    private Dimension _locationSize = new Dimension(10, 10);
    private Hashtable _specifications = new Hashtable();

    public DebuggerGraphic(Component component) {
        super(component);
    }

    public void add(PhetGraphic phetGraphic) {
        this.add(phetGraphic, this._boundsColor, this._locationColor);
    }

    public void add(PhetGraphic phetGraphic, Color color, Color color2) {
        this._specifications.put(phetGraphic, new Specification(color, color2));
    }

    public void setBoundsColor(Color color) {
        this._boundsColor = color;
    }

    public void setLocationColor(Color color) {
        this._locationColor = color;
    }

    public void setBoundsEnabled(boolean bl) {
        this._boundsEnabled = bl;
    }

    public boolean isBoundsEnabled() {
        return this._boundsEnabled;
    }

    public void setLocationEnabled(boolean bl) {
        this._locationEnabled = bl;
    }

    public boolean isLocationEnabled() {
        return this._locationEnabled;
    }

    protected Rectangle determineBounds() {
        Rectangle rectangle = null;
        Enumeration enumeration = this._specifications.keys();
        while (enumeration.hasMoreElements()) {
            PhetGraphic phetGraphic = (PhetGraphic)enumeration.nextElement();
            if (rectangle == null) {
                rectangle = new Rectangle();
            }
            rectangle.union(phetGraphic.getBounds());
        }
        return rectangle;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible() && (this.isBoundsEnabled() || this.isLocationEnabled())) {
            this.saveGraphicsState(graphics2D);
            Enumeration enumeration = this._specifications.keys();
            while (enumeration.hasMoreElements()) {
                PhetGraphic phetGraphic = (PhetGraphic)enumeration.nextElement();
                Rectangle rectangle = phetGraphic.getBounds();
                Point point = phetGraphic.getLocation();
                Specification specification = (Specification)this._specifications.get(phetGraphic);
                if (this.isBoundsEnabled()) {
                    graphics2D.setStroke(this._boundsStroke);
                    graphics2D.setPaint(specification.boundsColor);
                    graphics2D.draw(rectangle);
                }
                if (!this.isLocationEnabled()) continue;
                graphics2D.setStroke(this._locationStroke);
                graphics2D.setPaint(specification.locationColor);
                graphics2D.drawLine(point.x, point.y - this._locationSize.height / 2, point.x, point.y + this._locationSize.height / 2);
                graphics2D.drawLine(point.x - this._locationSize.width / 2, point.y, point.x + this._locationSize.width / 2, point.y);
            }
            this.restoreGraphicsState();
        }
    }

    private static class Specification {
        public Color boundsColor;
        public Color locationColor;

        public Specification(Color color, Color color2) {
            this.boundsColor = color;
            this.locationColor = color2;
        }
    }
}

