/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view.phetgraphics;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;

public class PhetMultiLineTextGraphic
extends CompositePhetGraphic {
    private LineCreator lineCreator;
    private String[] text;
    private FontMetrics fontMetrics;

    public PhetMultiLineTextGraphic(Component component, String[] stringArray, Font font, int n, int n2, Color color) {
        this(component, stringArray, font, n, n2, new Basic(component, font, color));
    }

    public PhetMultiLineTextGraphic(Component component, String[] stringArray, Font font, int n, int n2, LineCreator lineCreator) {
        super(component);
        this.text = stringArray;
        this.lineCreator = lineCreator;
        this.fontMetrics = component.getFontMetrics(font);
        this.init();
        this.setLocation(n, n2);
    }

    private void init() {
        this.clear();
        int n = 0;
        for (int i = 0; i < this.text.length; ++i) {
            String string = this.text[i];
            PhetGraphic phetGraphic = this.lineCreator.createLine(string, 0, n);
            this.addGraphic(phetGraphic);
            n += this.fontMetrics.getDescent() + this.fontMetrics.getLeading() + this.fontMetrics.getAscent();
        }
    }

    public PhetMultiLineTextGraphic() {
    }

    static class Basic
    implements LineCreator {
        private Font font;
        private Color color;
        private Component component;

        public Basic(Component component, Font font, Color color) {
            this.component = component;
            this.font = font;
            this.color = color;
        }

        public PhetGraphic createLine(String string, int n, int n2) {
            return new PhetTextGraphic(this.component, this.font, string, this.color, n, n2);
        }
    }

    public static interface LineCreator {
        public PhetGraphic createLine(String var1, int var2, int var3);
    }
}

